/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;

public interface ComponentFactory
extends Serializable {
    public ComponentType getComponentType();

    public ApplicationAdvice appliesTo(ComponentType var1, IModel<?> var2);

    public Component createComponent(IModel<?> var1);

    public Component createComponent(String var1, IModel<?> var2);

    public String getName();

    public CssResourceReference getCssResourceReference();

    public static enum ApplicationAdvice {
        APPLIES(true, false),
        APPLIES_EXCLUSIVELY(true, true),
        DOES_NOT_APPLY(false, false);

        private final boolean applies;
        private final boolean exclusively;

        private ApplicationAdvice(boolean applies, boolean exclusively) {
            this.applies = applies;
            this.exclusively = exclusively;
        }

        public boolean applies() {
            return this.applies;
        }

        public boolean exclusively() {
            return this.exclusively;
        }

        public static final ApplicationAdvice appliesIf(boolean b) {
            return b ? APPLIES : DOES_NOT_APPLY;
        }
    }
}

