/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import java.net.URL;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;

public enum ActionResultResponseHandlingStrategy {
    REDIRECT_TO_VOID{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            component.setResponsePage((Page)new VoidReturnPage(new VoidModel()));
        }
    }
    ,
    REDIRECT_TO_PAGE{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            IsisContext.getTransactionManager().flushTransaction();
            component.setResponsePage((Page)resultResponse.getToPage());
        }
    }
    ,
    SCHEDULE_HANDLER{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            RequestCycle requestCycle = component.getRequestCycle();
            requestCycle.scheduleRequestHandlerAfterCurrent(resultResponse.getHandler());
        }
    }
    ,
    OPEN_URL_IN_BROWSER{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            AjaxRequestTarget target = resultResponse.getTarget();
            URL url = resultResponse.getUrl();
            RequestCycle requestCycle = component.getRequestCycle();
            String fullUrl = 4.expanded(requestCycle, url);
            target.appendJavaScript((CharSequence)("setTimeout(function(){isisOpenInNewTab('" + fullUrl + "')}, 100);"));
        }
    };


    public abstract void handleResults(Component var1, ActionResultResponse var2);

    public static String expanded(RequestCycle requestCycle, URL url) {
        String urlStr = ActionResultResponseHandlingStrategy.expanded(url);
        return requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlStr));
    }

    public static String expanded(URL url) {
        return ActionResultResponseHandlingStrategy.expanded(url.toString());
    }

    public static String expanded(String urlStr) {
        if (urlStr.contains("antiCache=${currentTimeMillis}")) {
            urlStr = urlStr.replace("antiCache=${currentTimeMillis}", "antiCache=" + System.currentTimeMillis());
        }
        return urlStr;
    }
}

