/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionprompt;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;

public class ActionPromptModalWindow
extends ModalWindow
implements ActionPrompt {
    private static final long serialVersionUID = 1L;

    public static ActionPromptModalWindow getActionPromptModalWindowIfEnabled(ActionPromptModalWindow modalWindow) {
        return !ActionPromptModalWindow.isActionPromptModalDialogDisabled() ? modalWindow : null;
    }

    public static boolean isActionPromptModalDialogDisabled() {
        return ActionPromptModalWindow.getConfiguration().getBoolean("isis.viewer.wicket.disableModalDialogs", false);
    }

    private static IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    public static ActionPromptModalWindow newModalWindow(String id) {
        ActionPromptModalWindow modalWindow = new ActionPromptModalWindow(id);
        modalWindow.setAutoSize(true);
        modalWindow.setResizable(false);
        modalWindow.setCssClassName("w_isis");
        return modalWindow;
    }

    public ActionPromptModalWindow(String id) {
        super(id);
        this.setMaskType(ModalWindow.MaskType.SEMI_TRANSPARENT);
        this.add(new Behavior[]{new CloseOnEscapeKeyBehavior(this)});
    }

    public void setPanel(Component component, AjaxRequestTarget target) {
        this.setContent(component);
    }

    public void show(AjaxRequestTarget target) {
        target.prependJavaScript((CharSequence)"Wicket.Window.unloadConfirmation = false;");
        super.show(target);
        StringBuilder builder = new StringBuilder();
        builder.append("$('.first-field input').focus();");
        builder.append("Wicket.Window.get().autoSizeWindow();\n");
        target.appendJavaScript((CharSequence)builder.toString());
    }

    private static class CloseOnEscapeKeyBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final ModalWindow modal;

        public CloseOnEscapeKeyBehavior(ModalWindow modal) {
            this.modal = modal;
        }

        protected void respond(AjaxRequestTarget target) {
            if (this.modal.isShown()) {
                this.modal.close(target);
            }
        }

        public void renderHead(Component component, IHeaderResponse response) {
            String javaScript = "$(document).ready(function() {\n  $(document).bind('keyup', function(evt) {\n    if (evt.keyCode == 27) {\n" + this.getCallbackScript() + "\n" + "        evt.preventDefault();\n" + "    }\n" + "  });\n" + "});";
            String id = "closeModal";
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)javaScript, (String)id));
        }
    }
}

