/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.additionallinks;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.ListOfLinksModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;

public class AdditionalLinksPanel
extends PanelAbstract<ListOfLinksModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINK_LIST = "additionalLinkList";
    private static final String ID_ADDITIONAL_LINK_ITEM = "additionalLinkItem";
    private static final String ID_ADDITIONAL_LINK_TITLE = "additionalLinkTitle";
    private List<LinkAndLabel> linkAndLabels = (List)((ListOfLinksModel)this.getModel()).getObject();

    public AdditionalLinksPanel(String id, List<LinkAndLabel> links) {
        super(id, new ListOfLinksModel(links));
        WebMarkupContainer container = new WebMarkupContainer(ID_ADDITIONAL_LINK_LIST);
        this.addOrReplace(new Component[]{container});
        container.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        ListView<LinkAndLabel> listView = new ListView<LinkAndLabel>(ID_ADDITIONAL_LINK_ITEM, this.linkAndLabels){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<LinkAndLabel> item) {
                LinkAndLabel linkAndLabel = (LinkAndLabel)item.getModelObject();
                AbstractLink link = linkAndLabel.getLink();
                Label viewTitleLabel = new Label(AdditionalLinksPanel.ID_ADDITIONAL_LINK_TITLE, linkAndLabel.getLabel());
                String disabledReasonIfAny = linkAndLabel.getDisabledReasonIfAny();
                if (disabledReasonIfAny != null) {
                    viewTitleLabel.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)disabledReasonIfAny))});
                }
                if (linkAndLabel.isBlobOrClob()) {
                    link.add(new Behavior[]{new CssClassAppender("noVeil")});
                }
                if (linkAndLabel.isPrototype()) {
                    link.add(new Behavior[]{new CssClassAppender("prototype")});
                }
                link.add(new Behavior[]{new CssClassAppender(linkAndLabel.getActionIdentifier())});
                String cssClass = linkAndLabel.getCssClass();
                if (cssClass != null) {
                    item.add(new Behavior[]{new CssClassAppender(cssClass)});
                }
                viewTitleLabel.add(new Behavior[]{new CssClassAppender(StringExtensions.asLowerDashed((String)linkAndLabel.getLabel()))});
                link.addOrReplace(new Component[]{viewTitleLabel});
                item.addOrReplace(new Component[]{link});
            }
        };
        container.addOrReplace(new Component[]{listView});
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        PanelUtil.renderHead(response, ((Object)((Object)this)).getClass());
    }
}

