/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.additionallinks;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.entity.EntityActionLinkFactory;
import org.apache.wicket.Session;

public final class EntityActionUtil {
    private static final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);

    private EntityActionUtil() {
    }

    public static List<LinkAndLabel> entityActions(EntityModel entityModel, ObjectAssociation association, final ActionPromptProvider actionPromptModalWindowProvider) {
        ArrayList associatedActions = Lists.newArrayList();
        EntityActionUtil.addActions(ActionType.USER, entityModel, association, associatedActions);
        if (EntityActionUtil.getDeploymentType().isPrototyping()) {
            EntityActionUtil.addActions(ActionType.EXPLORATION, entityModel, association, associatedActions);
            EntityActionUtil.addActions(ActionType.PROTOTYPE, entityModel, association, associatedActions);
        }
        Collections.sort(associatedActions, new Comparator<ObjectAction>(){

            @Override
            public int compare(ObjectAction o1, ObjectAction o2) {
                MemberOrderFacet m1 = (MemberOrderFacet)o1.getFacet(MemberOrderFacet.class);
                MemberOrderFacet m2 = (MemberOrderFacet)o2.getFacet(MemberOrderFacet.class);
                return memberOrderFacetComparator.compare(m1, m2);
            }
        });
        final EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(entityModel);
        final ObjectAdapterMemento adapterMemento = entityModel.getObjectAdapterMemento();
        return Lists.transform((List)associatedActions, (Function)new Function<ObjectAction, LinkAndLabel>(){

            public LinkAndLabel apply(ObjectAction objectAction) {
                return linkFactory.newLink(adapterMemento, objectAction, "additionalLink", actionPromptModalWindowProvider);
            }
        });
    }

    protected static DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }

    protected static List<ObjectAction> addActions(ActionType type, EntityModel entityModel, ObjectAssociation association, List<ObjectAction> associatedActions) {
        ObjectSpecification adapterSpec = entityModel.getTypeOfSpecification();
        ObjectAdapter adapter = entityModel.load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        Filter filter = Filters.and((Filter[])new Filter[]{ObjectAction.Filters.memberOrderOf((ObjectAssociation)association), EntityActionUtil.dynamicallyVisibleFor(adapter), ObjectAction.Filters.notBulkOnly()});
        List userActions = adapterSpec.getObjectActions(type, Contributed.INCLUDED, filter);
        associatedActions.addAll(userActions);
        return userActions;
    }

    private static Filter<ObjectAction> dynamicallyVisibleFor(ObjectAdapter adapter) {
        AuthenticationSessionProvider asa = (AuthenticationSessionProvider)Session.get();
        AuthenticationSession authSession = asa.getAuthenticationSession();
        return ObjectAction.Filters.dynamicallyVisible((AuthenticationSession)authSession, (ObjectAdapter)adapter, (Where)Where.ANYWHERE);
    }
}

