/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.appactions.cssmenu;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.progmodel.facets.actions.notinservicemenu.NotInServiceMenuFacet;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.ApplicationActionsModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.appactions.cssmenu.AppActionsCssMenuLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class AppActionsCssMenuFactory
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;
    private static final ActionLinkFactory cssMenuLinkFactory = new AppActionsCssMenuLinkFactory();

    public AppActionsCssMenuFactory() {
        super(ComponentType.APPLICATION_ACTIONS, CssMenuPanel.class);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        return this.appliesIf(model instanceof ApplicationActionsModel);
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        ApplicationActionsModel applicationActionsModel = (ApplicationActionsModel)model;
        return new CssMenuPanel(id, CssMenuPanel.Style.REGULAR, this.buildMenu(applicationActionsModel));
    }

    private List<CssMenuItem> buildMenu(ApplicationActionsModel appActionsModel) {
        List serviceAdapters = (List)appActionsModel.getObject();
        ArrayList serviceActions = Lists.newArrayList();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            AppActionsCssMenuFactory.collateServiceActions(serviceAdapter, ActionType.USER, serviceActions);
            AppActionsCssMenuFactory.collateServiceActions(serviceAdapter, ActionType.PROTOTYPE, serviceActions);
        }
        List<String> serviceNamesInOrder = this.serviceNamesInOrder(serviceAdapters, serviceActions);
        Map<String, List<LogicalServiceAction>> serviceActionsByName = AppActionsCssMenuFactory.groupByServiceName(serviceActions);
        serviceNamesInOrder.retainAll(serviceActionsByName.keySet());
        return this.buildMenuItems(serviceNamesInOrder, serviceActionsByName, appActionsModel.getActionPromptModalWindowProvider());
    }

    private List<CssMenuItem> buildMenuItems(List<String> serviceNamesInOrder, Map<String, List<LogicalServiceAction>> serviceActionsByName, ActionPromptProvider actionPromptModalWindowProvider) {
        ArrayList menuItems = Lists.newArrayList();
        for (String serviceName : serviceNamesInOrder) {
            CssMenuItem serviceMenuItem = CssMenuItem.newMenuItem(serviceName).build();
            List<LogicalServiceAction> serviceActionsForName = serviceActionsByName.get(serviceName);
            for (LogicalServiceAction logicalServiceAction : serviceActionsForName) {
                ObjectAction objectAction;
                ObjectAdapterMemento serviceAdapterMemento;
                CssMenuItem.Builder subMenuItemBuilder;
                ObjectAdapter serviceAdapter = logicalServiceAction.serviceAdapter;
                ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
                if (serviceSpec.isHidden() || (subMenuItemBuilder = serviceMenuItem.newSubMenuItem(serviceAdapterMemento = logicalServiceAction.serviceAdapterMemento, objectAction = logicalServiceAction.objectAction, cssMenuLinkFactory, actionPromptModalWindowProvider)) == null) continue;
                subMenuItemBuilder.build();
            }
            if (!serviceMenuItem.hasSubMenuItems()) continue;
            menuItems.add(serviceMenuItem);
        }
        return menuItems;
    }

    private static void collateServiceActions(ObjectAdapter serviceAdapter, ActionType actionType, List<LogicalServiceAction> serviceActions) {
        ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
        for (ObjectAction objectAction : serviceSpec.getObjectActions(actionType, Contributed.INCLUDED, Filters.any())) {
            String serviceName;
            if (objectAction.getFacet(NotInServiceMenuFacet.class) != null) continue;
            MemberOrderFacet memberOrderFacet = (MemberOrderFacet)objectAction.getFacet(MemberOrderFacet.class);
            String string = serviceName = memberOrderFacet != null ? memberOrderFacet.name() : null;
            if (Strings.isNullOrEmpty((String)serviceName)) {
                serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            }
            serviceActions.add(new LogicalServiceAction(serviceName, serviceAdapter, objectAction));
        }
    }

    private List<String> serviceNamesInOrder(List<ObjectAdapter> serviceAdapters, List<LogicalServiceAction> serviceActions) {
        ArrayList serviceNameOrder = Lists.newArrayList();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            String serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            serviceNameOrder.add(serviceName);
        }
        for (LogicalServiceAction serviceAction : serviceActions) {
            if (serviceNameOrder.contains(serviceAction.serviceName)) continue;
            serviceNameOrder.add(serviceAction.serviceName);
        }
        return serviceNameOrder;
    }

    private static Map<String, List<LogicalServiceAction>> groupByServiceName(List<LogicalServiceAction> serviceActions) {
        TreeMap serviceActionsByName = Maps.newTreeMap();
        for (LogicalServiceAction serviceAction : serviceActions) {
            List serviceActionsForName = (List)serviceActionsByName.get(serviceAction.serviceName);
            if (serviceActionsForName == null) {
                serviceActionsForName = Lists.newArrayList();
                serviceActionsByName.put(serviceAction.serviceName, serviceActionsForName);
            }
            serviceActionsForName.add(serviceAction);
        }
        return serviceActionsByName;
    }

    static class LogicalServiceAction {
        private final String serviceName;
        private final ObjectAdapter serviceAdapter;
        private final ObjectAdapterMemento serviceAdapterMemento;
        private final ObjectAction objectAction;

        LogicalServiceAction(String serviceName, ObjectAdapter serviceAdapter, ObjectAction objectAction) {
            this.serviceName = serviceName;
            this.serviceAdapter = serviceAdapter;
            this.serviceAdapterMemento = ObjectAdapterMemento.createOrNull((ObjectAdapter)serviceAdapter);
            this.objectAction = objectAction;
        }

        public String toString() {
            return this.serviceName + " ~ " + this.objectAction.getIdentifier().toFullIdentityString();
        }
    }
}

