/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.bookmarkedpages;

import com.google.inject.Inject;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.BookmarkTreeNode;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class BookmarkedPagesPanel
extends PanelAbstract<BookmarkedPagesModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BOOKMARK_LIST = "bookmarkList";
    private static final String ID_BOOKMARKED_PAGE_LINK = "bookmarkedPageLink";
    private static final String ID_CLEAR_BOOKMARK_LINK = "clearBookmarkLink";
    private static final String ID_BOOKMARKED_PAGE_ITEM = "bookmarkedPageItem";
    private static final String ID_BOOKMARKED_PAGE_TITLE = "bookmarkedPageTitle";
    private static final String ID_BOOKMARKED_PAGE_ICON = "bookmarkedPageImage";
    private static final String CLEAR_BOOKMARKS = "clearBookmarks";
    private static final JavaScriptResourceReference SLIDE_PANEL_JS = new JavaScriptResourceReference(BookmarkedPagesPanel.class, "slide-panel.js");
    @Inject
    private PageClassRegistry pageClassRegistry;
    @Inject
    private ImageResourceCache imageCache;

    public BookmarkedPagesPanel(String id, BookmarkedPagesModel bookmarkedPagesModel) {
        super(id, bookmarkedPagesModel);
        this.buildGui();
    }

    private void buildGui() {
        final WebMarkupContainer container = new WebMarkupContainer(ID_BOOKMARK_LIST){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)SLIDE_PANEL_JS));
            }
        };
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final BookmarkedPagesModel bookmarkedPagesModel = (BookmarkedPagesModel)this.getModel();
        AjaxLink<Void> clearAllBookmarksLink = new AjaxLink<Void>(CLEAR_BOOKMARKS){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ((BookmarkedPagesModel)BookmarkedPagesPanel.this.getModel()).clear();
                this.setEnabled(false);
                target.add(new Component[]{container, this});
            }
        };
        clearAllBookmarksLink.setOutputMarkupId(true);
        this.add(new Component[]{clearAllBookmarksLink});
        clearAllBookmarksLink.setOutputMarkupId(true);
        if (((BookmarkedPagesModel)this.getModel()).isEmpty()) {
            clearAllBookmarksLink.setVisible(false);
        }
        ListView<BookmarkTreeNode> listView = new ListView<BookmarkTreeNode>(ID_BOOKMARKED_PAGE_ITEM, (IModel)bookmarkedPagesModel, (AjaxLink)clearAllBookmarksLink){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ AjaxLink val$clearAllBookmarksLink;
            {
                this.val$clearAllBookmarksLink = ajaxLink;
                super(x0, x1);
            }

            protected void populateItem(ListItem<BookmarkTreeNode> item) {
                final BookmarkTreeNode node = (BookmarkTreeNode)item.getModelObject();
                try {
                    PageType pageType = node.getPageType();
                    Class<? extends Page> pageClass = BookmarkedPagesPanel.this.pageClassRegistry.getPageClass(pageType);
                    AjaxLink<Object> clearBookmarkLink = new AjaxLink<Object>(BookmarkedPagesPanel.ID_CLEAR_BOOKMARK_LINK){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            bookmarkedPagesModel.remove(node);
                            if (bookmarkedPagesModel.isEmpty()) {
                                BookmarkedPagesPanel.this.permanentlyHide(BookmarkedPagesPanel.CLEAR_BOOKMARKS);
                            }
                            target.add(new Component[]{container, val$clearAllBookmarksLink});
                        }
                    };
                    if (node.getDepth() == 0) {
                        clearBookmarkLink.add(new Behavior[]{new CssClassAppender("clearBookmark")});
                    } else {
                        clearBookmarkLink.setEnabled(true);
                    }
                    item.add(new Component[]{clearBookmarkLink});
                    PageParameters pageParameters = node.getPageParameters();
                    AbstractLink link = Links.newBookmarkablePageLink(BookmarkedPagesPanel.ID_BOOKMARKED_PAGE_LINK, pageParameters, pageClass);
                    ObjectSpecification objectSpec = null;
                    RootOid oid = node.getOidNoVer();
                    if (oid != null) {
                        ObjectSpecId objectSpecId = oid.getObjectSpecId();
                        objectSpec = BookmarkedPagesPanel.this.getSpecificationLoader().lookupBySpecId(objectSpecId);
                    }
                    ResourceReference imageResource = BookmarkedPagesPanel.this.imageCache.resourceReferenceForSpec(objectSpec);
                    Image image = new Image(BookmarkedPagesPanel.ID_BOOKMARKED_PAGE_ICON, imageResource){
                        private static final long serialVersionUID = 1L;

                        protected boolean shouldAddAntiCacheParameter() {
                            return false;
                        }
                    };
                    link.addOrReplace(new Component[]{image});
                    String title = node.getTitle();
                    Label label = new Label(BookmarkedPagesPanel.ID_BOOKMARKED_PAGE_TITLE, title);
                    link.add(new Component[]{label});
                    item.add(new Component[]{link});
                    if (bookmarkedPagesModel.isCurrent(pageParameters)) {
                        item.add(new Behavior[]{new CssClassAppender("currentBookmark")});
                    }
                    item.add(new Behavior[]{new CssClassAppender("bookmarkDepth" + node.getDepth())});
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
        };
        container.add(new Component[]{listView});
    }

    protected ImageResourceCache getImageCache() {
        return this.imageCache;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

