/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import java.util.List;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.additionallinks.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<EntityCollectionModel>
implements ActionPromptProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_COLLECTION = "collection";
    private static final String ID_FEEDBACK = "feedback";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private Component collectionContents;
    private String collectionName;
    private Label label;
    private ActionPromptModalWindow actionPromptModalWindow;

    public CollectionPanel(String id, EntityModel entityModel, OneToManyAssociation otma) {
        this(id, CollectionPanel.newEntityCollectionModel(entityModel, otma), entityModel, otma);
    }

    private static EntityCollectionModel newEntityCollectionModel(EntityModel entityModel, OneToManyAssociation otma) {
        EntityCollectionModel collectionModel = EntityCollectionModel.createParented((EntityModel)entityModel, (OneToManyAssociation)otma);
        return collectionModel;
    }

    CollectionPanel(String id, EntityCollectionModel collectionModel) {
        this(id, collectionModel, new EntityModel(collectionModel.getParentObjectAdapterMemento()), collectionModel.getCollectionMemento().getCollection());
    }

    CollectionPanel(String id, EntityCollectionModel collectionModel, EntityModel entityModel, OneToManyAssociation otma) {
        super(id, collectionModel);
        this.addActionPromptModalWindow();
        List<LinkAndLabel> entityActions = EntityActionUtil.entityActions(entityModel, (ObjectAssociation)otma, this);
        collectionModel.addEntityActions(entityActions);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        WebMarkupContainer markupContainer = new WebMarkupContainer(ID_COLLECTION);
        this.collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)markupContainer, ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new ComponentFeedbackPanel(ID_FEEDBACK, this.collectionContents)});
        this.addOrReplace(new Component[]{markupContainer});
    }

    public Label createLabel(String id, String collectionName) {
        this.collectionName = collectionName;
        this.label = new Label(id, this.labelTextFor(this.getCount()));
        this.label.setOutputMarkupId(true);
        return this.label;
    }

    public void updateLabel(AjaxRequestTarget target) {
        target.add(new Component[]{this.label});
    }

    public boolean hasCount() {
        if (this.label == null) {
            return false;
        }
        Integer count = this.getCount();
        this.label.setDefaultModelObject((Object)this.labelTextFor(count));
        return count != null;
    }

    private Integer getCount() {
        if (this.collectionContents instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.collectionContents;
            return collectionCountProvider.getCount();
        }
        return null;
    }

    private String labelTextFor(Integer count) {
        String labelText = this.collectionName + (count != null ? " (" + count + ")" : " (+)");
        return labelText;
    }

    public ActionPromptModalWindow getActionPrompt() {
        return ActionPromptModalWindow.getActionPromptModalWindowIfEnabled(this.actionPromptModalWindow);
    }

    private void addActionPromptModalWindow() {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }
}

