/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;

final class BulkActionsLinkFactory
implements ActionLinkFactory {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel model;
    private final DataTable<ObjectAdapter, String> dataTable;
    private final ObjectAdapterToggleboxColumn toggleboxColumn;

    BulkActionsLinkFactory(EntityCollectionModel model, DataTable<ObjectAdapter, String> dataTable, ObjectAdapterToggleboxColumn toggleboxColumn) {
        this.model = model;
        this.dataTable = dataTable;
        this.toggleboxColumn = toggleboxColumn;
    }

    @Override
    public LinkAndLabel newLink(ObjectAdapterMemento serviceAdapterMemento, ObjectAction objectAction, String linkId, ActionPromptProvider actionPromptModalWindowProvider) {
        final ActionMemento actionMemento = new ActionMemento(objectAction);
        Link<Object> link = new Link<Object>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                ObjectAction objectAction = actionMemento.getAction();
                AdapterManager.ConcurrencyChecking concurrencyChecking = AdapterManager.ConcurrencyChecking.concurrencyCheckingFor((ActionSemantics.Of)objectAction.getSemantics());
                try {
                    Command command;
                    CommandContext commandContext;
                    List toggleMementosList = BulkActionsLinkFactory.this.model.getToggleMementosList();
                    Iterable toggledAdapters = Iterables.transform((Iterable)toggleMementosList, (Function)ObjectAdapterMemento.Functions.fromMemento((AdapterManager.ConcurrencyChecking)concurrencyChecking));
                    ArrayList domainObjects = Lists.newArrayList((Iterable)Iterables.transform((Iterable)toggledAdapters, (Function)ObjectAdapter.Functions.getObject()));
                    Bulk.InteractionContext bulkInteractionContext = (Bulk.InteractionContext)Bulk.InteractionContext.current.get();
                    if (bulkInteractionContext != null) {
                        bulkInteractionContext.setInvokedAs(Bulk.InteractionContext.InvokedAs.BULK);
                        bulkInteractionContext.setDomainObjects((List)domainObjects);
                    }
                    if ((commandContext = (CommandContext)BulkActionsLinkFactory.this.getServicesInjector().lookupService(CommandContext.class)) != null) {
                        command = commandContext.getCommand();
                        command.setExecutor(Command.Executor.USER);
                    } else {
                        command = null;
                    }
                    ObjectAdapter lastReturnedAdapter = null;
                    int i = 0;
                    for (ObjectAdapter adapter : toggledAdapters) {
                        int numParameters = objectAction.getParameterCount();
                        if (numParameters != 0) {
                            return;
                        }
                        if (bulkInteractionContext != null) {
                            bulkInteractionContext.setIndex(i++);
                        }
                        lastReturnedAdapter = objectAction.execute(adapter, new ObjectAdapter[0]);
                    }
                    BulkActionsLinkFactory.this.model.clearToggleMementosList();
                    BulkActionsLinkFactory.this.toggleboxColumn.clearToggles();
                    ActionModel actionModelHint = BulkActionsLinkFactory.this.model.getActionModelHint();
                    if (actionModelHint != null && actionModelHint.getActionMemento().getAction().getSemantics().isIdempotentInNature()) {
                        ObjectAdapter resultAdapter = (ObjectAdapter)actionModelHint.getObject();
                        BulkActionsLinkFactory.this.model.setObjectList(resultAdapter);
                    } else {
                        BulkActionsLinkFactory.this.model.setObject(this.persistentAdaptersWithin((List)BulkActionsLinkFactory.this.model.getObject()));
                    }
                    if (lastReturnedAdapter != null) {
                        ActionResultResponse resultResponse = ActionResultResponseType.determineAndInterpretResult(actionModelHint, null, lastReturnedAdapter);
                        resultResponse.getHandlingStrategy().handleResults((Component)this, resultResponse);
                    }
                }
                catch (ConcurrencyException ex) {
                    this.recover();
                    BulkActionsLinkFactory.this.getMessageBroker().addWarning(ex.getMessage());
                    return;
                }
                catch (RuntimeException ex) {
                    RecoverableException appEx = ActionModel.getApplicationExceptionIfAny((Exception)ex);
                    if (appEx != null) {
                        this.recover();
                        BulkActionsLinkFactory.this.getMessageBroker().setApplicationError(appEx.getMessage());
                        return;
                    }
                    throw ex;
                }
            }

            private void recover() {
                ArrayList toggleMementosList = Lists.newArrayList((Iterable)BulkActionsLinkFactory.this.model.getToggleMementosList());
                for (ObjectAdapterMemento oam : toggleMementosList) {
                    oam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                }
                BulkActionsLinkFactory.this.model.setObject(this.persistentAdaptersWithin((List)BulkActionsLinkFactory.this.model.getObject()));
                List adapters = (List)BulkActionsLinkFactory.this.model.getObject();
                BulkActionsLinkFactory.this.model.clearToggleMementosList();
                for (ObjectAdapterMemento oam : toggleMementosList) {
                    ObjectAdapter objectAdapter = oam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                    if (!adapters.contains(objectAdapter)) continue;
                    BulkActionsLinkFactory.this.model.toggleSelectionOn(objectAdapter);
                }
            }

            private List<ObjectAdapter> persistentAdaptersWithin(List<ObjectAdapter> adapters) {
                return Lists.newArrayList((Iterable)Iterables.filter(adapters, (Predicate)new Predicate<ObjectAdapter>(){

                    public boolean apply(ObjectAdapter input) {
                        return !input.isTransient() && !input.isDestroyed();
                    }
                }));
            }
        };
        link.add(new Behavior[]{new JGrowlBehaviour()});
        boolean explorationOrPrototype = CssMenuItem.isExplorationOrPrototype(objectAction);
        String actionIdentifier = CssMenuItem.actionIdentifierFor(objectAction);
        String cssClass = CssMenuItem.cssClassFor(objectAction);
        return new LinkAndLabel((AbstractLink)link, objectAction.getName(), null, false, explorationOrPrototype, actionIdentifier, cssClass);
    }

    public AuthenticationSession getAuthenticationSession() {
        AuthenticationSessionProvider asa = (AuthenticationSessionProvider)Session.get();
        return asa.getAuthenticationSession();
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }

    protected ServicesInjector getServicesInjector() {
        return IsisContext.getPersistenceSession().getServicesInjector();
    }
}

