/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.common.SelectionHandler;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.BulkActionsLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterPropertyColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterTitleColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuBuilder;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider,
ActionPromptProvider,
UiHintPathSignificant {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";
    private static final String ID_ENTITY_ACTIONS = "entityActions";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final Predicate<ObjectAction> BULK = Filters.asPredicate((Filter)ObjectAction.Filters.bulk());
    private IsisAjaxFallbackDataTable<ObjectAdapter, String> dataTable;
    private ActionPromptModalWindow actionPromptModalWindow;
    @Inject
    private WicketViewerSettings settings;

    public CollectionContentsAsAjaxTablePanel(String id, EntityCollectionModel model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        ArrayList columns = Lists.newArrayList();
        List<ObjectAction> bulkActions = this.determineBulkActions();
        ObjectAdapterToggleboxColumn toggleboxColumn = this.addToggleboxColumnIfRequired(columns, bulkActions);
        this.addTitleColumn(columns, model.getParentObjectAdapterMemento(), this.getSettings().getMaxTitleLengthInStandaloneTables(), this.getSettings().getMaxTitleLengthInStandaloneTables());
        this.addPropertyColumnsIfRequired(columns);
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider(model);
        this.dataTable = new IsisAjaxFallbackDataTable(ID_TABLE, columns, dataProvider, model.getPageSize());
        this.addActionPromptModalWindow();
        this.buildEntityActionsGui(bulkActions, this, toggleboxColumn);
        this.addOrReplace(new Component[]{this.dataTable});
        this.dataTable.honourHints();
    }

    private ObjectAdapterToggleboxColumn addToggleboxColumnIfRequired(List<IColumn<ObjectAdapter, String>> columns, List<ObjectAction> bulkActions) {
        final EntityCollectionModel entityCollectionModel = (EntityCollectionModel)this.getModel();
        if (bulkActions.isEmpty() || entityCollectionModel.isParented()) {
            return null;
        }
        ObjectAdapterToggleboxColumn toggleboxColumn = new ObjectAdapterToggleboxColumn(new SelectionHandler(){
            private static final long serialVersionUID = 1L;

            public void onSelected(Component context, ObjectAdapter selectedAdapter, AjaxRequestTarget ajaxRequestTarget) {
                entityCollectionModel.toggleSelectionOn(selectedAdapter);
            }

            public void onConcurrencyException(Component context, ObjectAdapter selectedAdapter, ConcurrencyException ex, AjaxRequestTarget ajaxRequestTarget) {
                ajaxRequestTarget.add(new Component[]{CollectionContentsAsAjaxTablePanel.this.dataTable});
            }
        });
        columns.add((IColumn<ObjectAdapter, String>)toggleboxColumn);
        return toggleboxColumn;
    }

    private void buildEntityActionsGui(List<ObjectAction> bulkActions, ActionPromptProvider actionPromptModalWindowProvider, ObjectAdapterToggleboxColumn toggleboxColumn) {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        if (bulkActions.isEmpty() || model.isParented()) {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
            return;
        }
        if (!bulkActions.isEmpty()) {
            BulkActionsLinkFactory linkFactory = new BulkActionsLinkFactory(model, this.dataTable, toggleboxColumn);
            CssMenuBuilder cssMenuBuilder = new CssMenuBuilder(null, this.getServiceAdapters(), bulkActions, linkFactory);
            CssMenuPanel cssMenuPanel = cssMenuBuilder.buildPanel(ID_ENTITY_ACTIONS, "Actions", actionPromptModalWindowProvider);
            this.addOrReplace(new Component[]{cssMenuPanel});
        } else {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
        }
    }

    private List<ObjectAction> determineBulkActions() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        if (model.isParented()) {
            return Collections.emptyList();
        }
        ObjectSpecification typeSpec = model.getTypeOfSpecification();
        List objectActions = typeSpec.getObjectActions(ActionType.USER, Contributed.INCLUDED, Filters.any());
        if (this.isExploring() || this.isPrototyping()) {
            List explorationActions = typeSpec.getObjectActions(ActionType.EXPLORATION, Contributed.INCLUDED, Filters.any());
            List prototypeActions = typeSpec.getObjectActions(ActionType.PROTOTYPE, Contributed.INCLUDED, Filters.any());
            objectActions.addAll(explorationActions);
            objectActions.addAll(prototypeActions);
        }
        if (this.isDebugMode()) {
            List debugActions = typeSpec.getObjectActions(ActionType.DEBUG, Contributed.INCLUDED, Filters.any());
            objectActions.addAll(debugActions);
        }
        List flattenedActions = objectActions;
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)flattenedActions, BULK));
    }

    private void addTitleColumn(List<IColumn<ObjectAdapter, String>> columns, ObjectAdapterMemento parentAdapterMementoIfAny, int maxTitleParented, int maxTitleStandalone) {
        int maxTitleLength = ((EntityCollectionModel)this.getModel()).isParented() ? maxTitleParented : maxTitleStandalone;
        columns.add((IColumn<ObjectAdapter, String>)new ObjectAdapterTitleColumn(parentAdapterMementoIfAny, maxTitleLength));
    }

    private void addPropertyColumnsIfRequired(List<IColumn<ObjectAdapter, String>> columns) {
        ObjectSpecification typeOfSpec = ((EntityCollectionModel)this.getModel()).getTypeOfSpecification();
        Where whereContext = ((EntityCollectionModel)this.getModel()).isParented() ? Where.PARENTED_TABLES : Where.STANDALONE_TABLES;
        ObjectSpecification parentSpecIfAny = ((EntityCollectionModel)this.getModel()).isParented() ? ((EntityCollectionModel)this.getModel()).getParentObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK).getSpecification() : null;
        Filter filter = Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.PROPERTIES, ObjectAssociation.Filters.staticallyVisible((Where)whereContext), CollectionContentsAsAjaxTablePanel.associationDoesNotReferenceParent(parentSpecIfAny)});
        List propertyList = typeOfSpec.getAssociations(Contributed.INCLUDED, filter);
        for (ObjectAssociation property : propertyList) {
            ObjectAdapterPropertyColumn nopc = this.createObjectAdapterPropertyColumn(property);
            columns.add((IColumn<ObjectAdapter, String>)nopc);
        }
    }

    static Filter<ObjectAssociation> associationDoesNotReferenceParent(final ObjectSpecification parentSpec) {
        if (parentSpec == null) {
            return Filters.any();
        }
        return new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet facet = (HiddenFacet)association.getFacet(HiddenFacet.class);
                if (facet == null) {
                    return true;
                }
                if (facet.where() != Where.REFERENCES_PARENT) {
                    return true;
                }
                ObjectSpecification assocSpec = association.getSpecification();
                boolean associationSpecIsOfParentSpec = parentSpec.isOfType(assocSpec);
                boolean isVisible = !associationSpecIsOfParentSpec;
                return isVisible;
            }
        };
    }

    private ObjectAdapterPropertyColumn createObjectAdapterPropertyColumn(ObjectAssociation property) {
        return new ObjectAdapterPropertyColumn((IModel<String>)Model.of((Serializable)((Object)property.getName())), property.getId(), property.getId());
    }

    protected void onModelChanged() {
        this.buildGui();
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }

    public ActionPromptModalWindow getActionPrompt() {
        return ActionPromptModalWindow.getActionPromptModalWindowIfEnabled(this.actionPromptModalWindow);
    }

    private void addActionPromptModalWindow() {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }

    public boolean isExploring() {
        return IsisContext.getDeploymentType().isExploring();
    }

    public boolean isPrototyping() {
        return IsisContext.getDeploymentType().isPrototyping();
    }

    protected boolean isDebugMode() {
        return true;
    }

    protected WicketViewerSettings getSettings() {
        return this.settings;
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }
}

