/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import com.google.common.collect.Ordering;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;

public class CollectionContentsSortableDataProvider
extends SortableDataProvider<ObjectAdapter, String> {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel model;
    public static Ordering<ObjectAdapter> ORDERING_BY_NATURAL = new Ordering<ObjectAdapter>(){

        public int compare(ObjectAdapter p, ObjectAdapter q) {
            Object pPojo = p.getObject();
            Object qPojo = q.getObject();
            if (!(pPojo instanceof Comparable) || !(qPojo instanceof Comparable)) {
                return 0;
            }
            return this.naturalOrdering(pPojo, qPojo);
        }

        private int naturalOrdering(Object pPojo, Object qPojo) {
            Comparable pComparable = (Comparable)pPojo;
            Comparable qComparable = (Comparable)qPojo;
            return Ordering.natural().compare((Object)pComparable, (Object)qComparable);
        }
    };

    public CollectionContentsSortableDataProvider(EntityCollectionModel model) {
        this.model = model;
    }

    public Iterator<ObjectAdapter> iterator(long first, long count) {
        List<ObjectAdapter> adapters = this.sortedIfRequired((List)this.model.getObject(), (SortParam<String>)this.getSort());
        return adapters.subList((int)first, (int)(first + count)).iterator();
    }

    public IModel<ObjectAdapter> model(ObjectAdapter adapter) {
        return new EntityModel(adapter);
    }

    public long size() {
        return ((List)this.model.getObject()).size();
    }

    public void detach() {
        super.detach();
        this.model.detach();
    }

    private List<ObjectAdapter> sortedIfRequired(List<ObjectAdapter> adapters, SortParam<String> sort) {
        if (sort == null) {
            return adapters;
        }
        ObjectSpecification elementSpec = this.model.getTypeOfSpecification();
        String sortPropertyId = (String)sort.getProperty();
        try {
            ObjectAssociation sortProperty = elementSpec.getAssociation(sortPropertyId);
            if (sortProperty == null) {
                return adapters;
            }
            Ordering<ObjectAdapter> ordering = CollectionContentsSortableDataProvider.orderingBy(sortProperty, sort.isAscending());
            return ordering.sortedCopy(adapters);
        }
        catch (ObjectSpecificationException ex) {
            return adapters;
        }
    }

    public static Ordering<ObjectAdapter> orderingBy(final ObjectAssociation sortProperty, final boolean ascending) {
        Ordering<ObjectAdapter> ordering = new Ordering<ObjectAdapter>(){

            public int compare(ObjectAdapter p, ObjectAdapter q) {
                ObjectAdapter pSort = sortProperty.get(p);
                ObjectAdapter qSort = sortProperty.get(q);
                Ordering naturalOrdering = ascending ? ORDERING_BY_NATURAL.nullsFirst() : ORDERING_BY_NATURAL.nullsLast();
                return naturalOrdering.compare((Object)pSort, (Object)qSort);
            }
        };
        return ascending ? ordering : ordering.reverse();
    }
}

