/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackOrderByBorder;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxHeadersToolbar;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class IsisAjaxFallbackHeadersToolbar<S>
extends IsisAjaxHeadersToolbar<S> {
    private static final long serialVersionUID = 1L;
    private final ISortStateLocator<S> stateLocator;
    private IsisAjaxFallbackDataTable<?, S> table;

    public IsisAjaxFallbackHeadersToolbar(IsisAjaxFallbackDataTable<?, S> table, ISortStateLocator<S> stateLocator) {
        super(table, stateLocator);
        this.table = table;
        table.setOutputMarkupId(true);
        this.stateLocator = stateLocator;
    }

    protected void onInitialize() {
        super.onInitialize();
    }

    @Override
    protected WebMarkupContainer newSortableHeader(String borderId, S property, ISortStateLocator<S> locator) {
        return new IsisAjaxFallbackOrderByBorder<S>(borderId, this.table, property, locator, this.getAjaxCallListener());
    }

    protected IAjaxCallListener getAjaxCallListener() {
        return null;
    }

    void honourSortOrderHints() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder sortOrder : SortOrder.values()) {
            String property = uiHintContainer.getHint(this.table, sortOrder.name());
            if (property == null) continue;
            String propertyS = property;
            this.stateLocator.getSortState().setPropertySortOrder((Object)propertyS, sortOrder);
        }
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf(this.table);
    }
}

