/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class IsisAjaxHeadersToolbar<S>
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public <T> IsisAjaxHeadersToolbar(final DataTable<T, S> table, final ISortStateLocator<S> stateLocator) {
        super(table);
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(Model.of((Serializable)column));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                final IColumn column = (IColumn)item.getModelObject();
                WebMarkupContainer header = null;
                header = column.isSortable() ? IsisAjaxHeadersToolbar.this.newSortableHeader("header", column.getSortProperty(), stateLocator) : new WebMarkupContainer("header");
                if (column instanceof IStyledColumn) {
                    CssAttributeBehavior cssAttributeBehavior = new CssAttributeBehavior(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected String getCssClass() {
                            return ((IStyledColumn)column).getCssClass();
                        }
                    };
                    header.add(new Behavior[]{cssAttributeBehavior});
                }
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
                Label label = new Label("label");
                label = column.getHeader("label");
                header.add(new Component[]{label});
            }
        };
        this.add(new Component[]{headers});
    }

    protected WebMarkupContainer newSortableHeader(String headerId, S property, ISortStateLocator<S> locator) {
        return new OrderByBorder<S>(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                IsisAjaxHeadersToolbar.this.getTable().setCurrentPage(0L);
            }
        };
    }

    static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        CssAttributeBehavior() {
        }

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((CharSequence)className)) {
                tag.append("class", (CharSequence)className, " ");
            }
        }
    }
}

