/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public final class ObjectAdapterPropertyColumn
extends ColumnAbstract<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private final String propertyExpression;

    public ObjectAdapterPropertyColumn(IModel<String> columnNameModel, String sortProperty, String propertyName) {
        super(columnNameModel, sortProperty);
        this.propertyExpression = propertyName;
    }

    public void populateItem(Item<ICellPopulator<ObjectAdapter>> cellItem, String componentId, IModel<ObjectAdapter> rowModel) {
        Component component = this.createComponent(componentId, rowModel);
        cellItem.add(new Component[]{component});
    }

    private Component createComponent(String id, IModel<ObjectAdapter> rowModel) {
        ObjectAdapter adapter = (ObjectAdapter)rowModel.getObject();
        EntityModel model = new EntityModel(adapter);
        OneToOneAssociation property = (OneToOneAssociation)adapter.getSpecification().getAssociation(this.propertyExpression);
        PropertyMemento pm = new PropertyMemento(property);
        ScalarModel scalarModel = model.getPropertyModel(pm);
        scalarModel.setRenderingHint(EntityModel.RenderingHint.PROPERTY_COLUMN);
        scalarModel.toViewMode();
        ComponentFactory componentFactory = this.findComponentFactory(ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarModel);
        Component component = componentFactory.createComponent(id, (IModel<?>)scalarModel);
        return component;
    }
}

