/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class ObjectAdapterTitleColumn
extends ColumnAbstract<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private final ObjectAdapterMemento parentAdapterMementoIfAny;

    private static String columnName(ObjectAdapterMemento parentAdapterMementoIfAny, int maxTitleLength) {
        if (maxTitleLength == 0) {
            return "";
        }
        return (parentAdapterMementoIfAny != null ? "Related " : "") + "Object";
    }

    public ObjectAdapterTitleColumn(ObjectAdapterMemento parentAdapterMementoIfAny, int maxTitleLength) {
        super(ObjectAdapterTitleColumn.columnName(parentAdapterMementoIfAny, maxTitleLength));
        this.parentAdapterMementoIfAny = parentAdapterMementoIfAny;
    }

    public void populateItem(Item<ICellPopulator<ObjectAdapter>> cellItem, String componentId, IModel<ObjectAdapter> rowModel) {
        Component component = this.createComponent(componentId, rowModel);
        cellItem.add(new Component[]{component});
    }

    private Component createComponent(String id, IModel<ObjectAdapter> rowModel) {
        ObjectAdapter adapter = (ObjectAdapter)rowModel.getObject();
        EntityModel model = new EntityModel(adapter);
        model.setRenderingHint(this.parentAdapterMementoIfAny != null ? EntityModel.RenderingHint.PARENTED_TITLE_COLUMN : EntityModel.RenderingHint.STANDALONE_TITLE_COLUMN);
        model.setContextAdapterIfAny(this.parentAdapterMementoIfAny);
        ComponentFactory componentFactory = this.findComponentFactory(ComponentType.ENTITY_LINK, (IModel<?>)model);
        return componentFactory.createComponent(id, (IModel<?>)model);
    }
}

