/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.viewer.wicket.model.common.SelectionHandler;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.checkbox.ContainedToggleboxPanel;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public final class ObjectAdapterToggleboxColumn
extends ColumnAbstract<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private final SelectionHandler handler;
    private final List<ContainedToggleboxPanel> rowToggles = Lists.newArrayList();

    public ObjectAdapterToggleboxColumn(SelectionHandler handler) {
        super("");
        this.handler = handler;
    }

    public Component getHeader(String componentId) {
        ContainedToggleboxPanel toggle = new ContainedToggleboxPanel(componentId){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                for (ContainedToggleboxPanel toggle : ObjectAdapterToggleboxColumn.this.rowToggles) {
                    toggle.toggle(target);
                    target.add(new Component[]{toggle});
                }
            }
        };
        return toggle;
    }

    public void populateItem(Item<ICellPopulator<ObjectAdapter>> cellItem, String componentId, final IModel<ObjectAdapter> rowModel) {
        MarkupContainer row = cellItem.getParent().getParent();
        row.setOutputMarkupId(true);
        EntityModel entityModel = (EntityModel)rowModel;
        String concurrencyExceptionIfAny = entityModel.getAndClearConcurrencyExceptionIfAny();
        if (concurrencyExceptionIfAny != null) {
            row.add(new Behavior[]{new CssClassAppender("reloaded-after-concurrency-exception")});
        }
        ContainedToggleboxPanel toggle = new ContainedToggleboxPanel(componentId){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                EntityModel entityModel = (EntityModel)rowModel;
                ObjectAdapter selectedAdapter = null;
                try {
                    selectedAdapter = entityModel.load(AdapterManager.ConcurrencyChecking.CHECK);
                    ObjectAdapterToggleboxColumn.this.handler.onSelected((Component)this, selectedAdapter, target);
                }
                catch (ConcurrencyException ex) {
                    selectedAdapter = entityModel.load(AdapterManager.ConcurrencyChecking.CHECK);
                    ObjectAdapterToggleboxColumn.this.handler.onConcurrencyException((Component)this, selectedAdapter, ex, target);
                    entityModel.setException(ex);
                }
            }
        };
        this.rowToggles.add(toggle);
        toggle.setOutputMarkupId(true);
        cellItem.add(new Component[]{toggle});
    }

    public void clearToggles() {
        this.rowToggles.clear();
    }
}

