/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.selector.links;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.core.metamodel.facets.members.resolve.RenderFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.unresolved.CollectionContentsAsUnresolvedPanelFactory;
import org.apache.isis.viewer.wicket.ui.selector.links.LinksSelectorPanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;

public class CollectionContentsLinksSelectorPanel
extends LinksSelectorPanelAbstract<EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;

    public CollectionContentsLinksSelectorPanel(String id, EntityCollectionModel model, ComponentFactory factory) {
        super(id, ComponentType.COLLECTION_CONTENTS.toString(), model, factory);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        CollectionContentsLinksSelectorPanel.applyCssVisibility((Component)this.additionalLinks, this.selectedComponent instanceof CollectionCountProvider);
    }

    @Override
    protected EntityCollectionModel dummyOf(EntityCollectionModel model) {
        return model.asDummy();
    }

    @Override
    protected int determineInitialFactory(List<ComponentFactory> componentFactories, IModel<?> model) {
        int ajaxTableIdx;
        if (!CollectionContentsLinksSelectorPanel.hasRenderEagerlyFacet(model)) {
            for (int i = 0; i < componentFactories.size(); ++i) {
                if (!(componentFactories.get(i) instanceof CollectionContentsAsUnresolvedPanelFactory)) continue;
                return i;
            }
        }
        if ((ajaxTableIdx = CollectionContentsLinksSelectorPanel.findAjaxTable(componentFactories)) >= 0) {
            return ajaxTableIdx;
        }
        return 0;
    }

    @Override
    protected List<ComponentFactory> ordered(List<ComponentFactory> componentFactories) {
        return CollectionContentsLinksSelectorPanel.orderAjaxTableToEnd(componentFactories);
    }

    static List<ComponentFactory> orderAjaxTableToEnd(List<ComponentFactory> componentFactories) {
        int ajaxTableIdx = CollectionContentsLinksSelectorPanel.findAjaxTable(componentFactories);
        if (ajaxTableIdx >= 0) {
            ArrayList orderedFactories = Lists.newArrayList(componentFactories);
            ComponentFactory ajaxTableFactory = (ComponentFactory)orderedFactories.remove(ajaxTableIdx);
            orderedFactories.add(ajaxTableFactory);
            return orderedFactories;
        }
        return componentFactories;
    }

    private static int findAjaxTable(List<ComponentFactory> componentFactories) {
        for (int i = 0; i < componentFactories.size(); ++i) {
            if (!(componentFactories.get(i) instanceof CollectionContentsAsAjaxTablePanelFactory)) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasRenderEagerlyFacet(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return false;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        if (!entityCollectionModel.isParented()) {
            return false;
        }
        OneToManyAssociation collection = entityCollectionModel.getCollectionMemento().getCollection();
        RenderFacet renderFacet = (RenderFacet)collection.getFacet(RenderFacet.class);
        return renderFacet != null && renderFacet.value() == Render.Type.EAGERLY;
    }

    @Override
    protected void onSelect(AjaxRequestTarget target) {
        super.onSelect(target);
        for (CollectionContentsLinksSelectorPanel component = this; component != null; component = component.getParent()) {
            if (!(component instanceof CollectionPanel)) continue;
            CollectionPanel collectionPanel = (CollectionPanel)((Object)component);
            boolean hasCount = collectionPanel.hasCount();
            if (hasCount) {
                collectionPanel.updateLabel(target);
            }
            if (this.additionalLinks != null) {
                CollectionContentsLinksSelectorPanel.applyCssVisibility((Component)this.additionalLinks, hasCount);
            }
            return;
        }
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

