/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactoryAbstract;
import org.apache.wicket.markup.html.link.AbstractLink;

public final class EntityActionLinkFactory
extends ActionLinkFactoryAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityModel entityModel;

    public EntityActionLinkFactory(EntityModel entityModel) {
        this.entityModel = entityModel;
    }

    @Override
    public LinkAndLabel newLink(ObjectAdapterMemento adapterMemento, ObjectAction action, String linkId, ActionPromptProvider actionPromptModalWindowProvider) {
        ObjectAdapter adapter = adapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
        Boolean persistent = adapter.representsPersistent();
        if (!persistent.booleanValue()) {
            throw new IllegalArgumentException("Object '" + adapter.titleString(null) + "' is not persistent.");
        }
        AuthenticationSession session = this.getAuthenticationSession();
        Consent visibility = action.isVisible(session, adapter, Where.OBJECT_FORMS);
        if (visibility.isVetoed()) {
            return null;
        }
        AbstractLink link = this.newLink(linkId, adapter, action, actionPromptModalWindowProvider);
        Consent usability = action.isUsable(session, adapter, Where.OBJECT_FORMS);
        String disabledReasonIfAny = usability.getReason();
        if (disabledReasonIfAny != null) {
            link.setEnabled(false);
        }
        return this.newLinkAndLabel(action, link, disabledReasonIfAny);
    }

    protected IsisContext getIsisContext() {
        return IsisContext.getInstance();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }
}

