/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.collections;

import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.containers.UiHintPathSignificantWebMarkupContainer;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.RepeatingView;

public class EntityCollectionsPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_COLLECTIONS = "entityCollections";
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTIONS = "collections";
    private static final String ID_COLLECTION = "collection";
    private Label labelComponent;

    public EntityCollectionsPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
        this.buildGui();
    }

    private void buildGui() {
        this.buildEntityPropertiesAndOrCollectionsGui();
        this.setOutputMarkupId(true);
    }

    private void buildEntityPropertiesAndOrCollectionsGui() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        if (adapter != null) {
            this.addCollections();
        } else {
            this.permanentlyHide(ID_ENTITY_COLLECTIONS);
        }
    }

    private void addCollections() {
        EntityModel entityModel = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        ObjectSpecification noSpec = adapter.getSpecification();
        List<ObjectAssociation> associations = this.visibleCollections(adapter, noSpec);
        RepeatingView collectionRv = new RepeatingView(ID_COLLECTIONS);
        this.add(new Component[]{collectionRv});
        for (ObjectAssociation association : associations) {
            UiHintPathSignificantWebMarkupContainer collectionRvContainer = new UiHintPathSignificantWebMarkupContainer(collectionRv.newChildId());
            collectionRv.add(new Component[]{collectionRvContainer});
            this.addCollectionToForm(entityModel, association, collectionRvContainer);
        }
    }

    private void addCollectionToForm(EntityModel entityModel, ObjectAssociation association, WebMarkupContainer collectionRvContainer) {
        CssClassFacet facet = (CssClassFacet)association.getFacet(CssClassFacet.class);
        if (facet != null) {
            collectionRvContainer.add(new Behavior[]{new CssClassAppender(facet.value())});
        }
        WebMarkupContainer fieldset = new WebMarkupContainer(ID_COLLECTION_GROUP);
        collectionRvContainer.add(new Component[]{fieldset});
        OneToManyAssociation otma = (OneToManyAssociation)association;
        CollectionPanel collectionPanel = new CollectionPanel(ID_COLLECTION, entityModel, otma);
        this.labelComponent = collectionPanel.createLabel(ID_COLLECTION_NAME, association.getName());
        fieldset.add(new Component[]{this.labelComponent});
        fieldset.addOrReplace(new Component[]{collectionPanel});
    }

    private List<ObjectAssociation> visibleCollections(ObjectAdapter adapter, ObjectSpecification noSpec) {
        return noSpec.getAssociations(Contributed.INCLUDED, this.visibleCollectionsFilter(adapter));
    }

    private Filter<ObjectAssociation> visibleCollectionsFilter(ObjectAdapter adapter) {
        return Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.COLLECTIONS, ObjectAssociation.Filters.dynamicallyVisible((AuthenticationSession)this.getAuthenticationSession(), (ObjectAdapter)adapter, (Where)Where.PARENTED_TABLES)});
    }

    private void requestRepaintPanel(AjaxRequestTarget target) {
        if (target != null) {
            target.add(new Component[]{this});
        }
    }

    private EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    void toViewMode(AjaxRequestTarget target) {
        this.getEntityModel().toViewMode();
        this.requestRepaintPanel(target);
    }
}

