/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.header;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.lang.StringFunctions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionInvokeHandler;
import org.apache.isis.viewer.wicket.ui.components.entity.EntityActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuBuilder;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuPanel;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.actionprompt.ActionPromptPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;

public class EntityHeaderPanel
extends PanelAbstract<EntityModel>
implements ActionInvokeHandler {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ACTIONS = "entityActions";
    private final EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(this.getEntityModel());
    @Inject
    private ImageResourceCache imageCache;

    public EntityHeaderPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    public EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceIconAndTitle();
        this.buildEntityActionsGui();
    }

    private void addOrReplaceIconAndTitle() {
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)this.getEntityModel());
        Component component = componentFactory.createComponent((IModel<?>)this.getEntityModel());
        this.addOrReplace(new Component[]{component});
    }

    private void buildEntityActionsGui() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        ObjectAdapterMemento adapterMemento = model.getObjectAdapterMemento();
        if (adapter != null) {
            List<ObjectAction> topLevelActions = this.getTopLevelActions(adapter);
            if (!topLevelActions.isEmpty()) {
                CssMenuBuilder cssMenuBuilder = new CssMenuBuilder(adapterMemento, this.getServiceAdapters(), topLevelActions, this.linkFactory);
                CssMenuPanel cssMenuPanel = cssMenuBuilder.buildPanel(ID_ENTITY_ACTIONS, "Actions", ActionPromptProvider.Util.getFrom((Component)this));
                this.addOrReplace(new Component[]{cssMenuPanel});
            } else {
                this.permanentlyHide(ID_ENTITY_ACTIONS);
            }
        } else {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
        }
    }

    private List<ObjectAction> getTopLevelActions(ObjectAdapter adapter) {
        ArrayList topLevelActions = Lists.newArrayList();
        this.addTopLevelActions(adapter, ActionType.USER, topLevelActions);
        if (this.getDeploymentType().isPrototyping()) {
            this.addTopLevelActions(adapter, ActionType.EXPLORATION, topLevelActions);
            this.addTopLevelActions(adapter, ActionType.PROTOTYPE, topLevelActions);
        }
        return topLevelActions;
    }

    private void addTopLevelActions(ObjectAdapter adapter, ActionType actionType, List<ObjectAction> topLevelActions) {
        ObjectSpecification adapterSpec = adapter.getSpecification();
        Filter filter = Filters.and((Filter[])new Filter[]{EntityHeaderPanel.memberOrderNameNotAssociation(adapterSpec), this.dynamicallyVisibleFor(adapter), ObjectAction.Filters.notBulkOnly()});
        List userActions = adapterSpec.getObjectActions(actionType, Contributed.INCLUDED, filter);
        topLevelActions.addAll(userActions);
    }

    private static Filter<ObjectAction> memberOrderNameNotAssociation(ObjectSpecification adapterSpec) {
        List associations = adapterSpec.getAssociations(Contributed.INCLUDED);
        final List associationNames = Lists.transform((List)associations, (Function)Functions.compose((Function)StringFunctions.toLowerCase(), (Function)ObjectAssociation.Functions.toName()));
        final List associationIds = Lists.transform((List)associations, (Function)Functions.compose((Function)StringFunctions.toLowerCase(), (Function)ObjectAssociation.Functions.toId()));
        return new Filter<ObjectAction>(){

            public boolean accept(ObjectAction t) {
                MemberOrderFacet memberOrderFacet = (MemberOrderFacet)t.getFacet(MemberOrderFacet.class);
                if (memberOrderFacet == null || Strings.isNullOrEmpty((String)memberOrderFacet.name())) {
                    return true;
                }
                String memberOrderName = (String)StringFunctions.toLowerCase().apply((Object)memberOrderFacet.name());
                return !associationNames.contains(memberOrderName) && !associationIds.contains(memberOrderName);
            }
        };
    }

    protected Filter<ObjectAction> dynamicallyVisibleFor(ObjectAdapter adapter) {
        return ObjectAction.Filters.dynamicallyVisible((AuthenticationSession)this.getAuthenticationSession(), (ObjectAdapter)adapter, (Where)Where.ANYWHERE);
    }

    @Override
    public void onClick(ActionModel actionModel) {
        this.setResponsePage((Page)new ActionPromptPage(actionModel));
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }

    protected ImageResourceCache getImageCache() {
        return this.imageCache;
    }

    protected DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }
}

