/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.properties;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecifications;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.memento.Memento;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.containers.UiHintPathSignificantWebMarkupContainer;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.CancelHintRequired;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.ButtonWithPreValidateHook;
import org.apache.isis.viewer.wicket.ui.panels.FormAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class EntityPropertiesForm
extends FormAbstract<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private static final String ID_MEMBER_GROUP = "memberGroup";
    private static final String ID_MEMBER_GROUP_NAME = "memberGroupName";
    private static final String ID_LEFT_COLUMN = "leftColumn";
    private static final String ID_MIDDLE_COLUMN = "middleColumn";
    private static final String ID_RIGHT_COLUMN = "rightColumn";
    private static final String ID_ENTITY_COLLECTIONS = "entityCollections";
    private static final String ID_ENTITY_COLLECTIONS_OVERFLOW = "entityCollectionsOverflow";
    private static final String ID_PROPERTIES = "properties";
    private static final String ID_PROPERTY = "property";
    private static final String ID_EDIT_BUTTON = "edit";
    private static final String ID_OK_BUTTON = "ok";
    private static final String ID_CANCEL_BUTTON = "cancel";
    private static final String ID_FEEDBACK = "feedback";
    private final Component owningPanel;
    private Button editButton;
    private Button okButton;
    private Button cancelButton;
    private FeedbackPanel feedback;
    private boolean renderedFirstField;

    public EntityPropertiesForm(String id, EntityModel entityModel, Component owningPanel) {
        super(id, entityModel);
        this.owningPanel = owningPanel;
        this.buildGui();
        String concurrencyExceptionIfAny = entityModel.getAndClearConcurrencyExceptionIfAny();
        if (concurrencyExceptionIfAny != null) {
            this.error((Serializable)((Object)concurrencyExceptionIfAny));
        }
    }

    private void buildGui() {
        boolean addedProperties;
        EntityModel entityModel = (EntityModel)this.getModel();
        MemberGroupLayout.ColumnSpans columnSpans = ((MemberGroupLayoutFacet)((ObjectAdapter)entityModel.getObject()).getSpecification().getFacet(MemberGroupLayoutFacet.class)).getColumnSpans();
        this.renderedFirstField = false;
        WebMarkupContainer leftColumn = new WebMarkupContainer(ID_LEFT_COLUMN);
        this.add(new Component[]{leftColumn});
        if (columnSpans.getLeft() > 0) {
            addedProperties = this.addPropertiesInColumn((MarkupContainer)leftColumn, ObjectSpecifications.MemberGroupLayoutHint.LEFT, columnSpans);
            this.addButtons((MarkupContainer)leftColumn);
            this.addFeedbackGui((MarkupContainer)leftColumn);
        } else {
            Components.permanentlyHide((MarkupContainer)this, ID_LEFT_COLUMN);
            addedProperties = false;
        }
        if (!addedProperties) {
            Components.permanentlyHide((MarkupContainer)this, ID_EDIT_BUTTON, ID_OK_BUTTON, ID_CANCEL_BUTTON, ID_FEEDBACK);
        }
        if (columnSpans.getMiddle() > 0) {
            WebMarkupContainer middleColumn = new WebMarkupContainer(ID_MIDDLE_COLUMN);
            this.add(new Component[]{middleColumn});
            this.addPropertiesInColumn((MarkupContainer)middleColumn, ObjectSpecifications.MemberGroupLayoutHint.MIDDLE, columnSpans);
        } else {
            Components.permanentlyHide((MarkupContainer)this, ID_MIDDLE_COLUMN);
        }
        if (columnSpans.getRight() > 0) {
            WebMarkupContainer rightColumn = new WebMarkupContainer(ID_RIGHT_COLUMN);
            this.add(new Component[]{rightColumn});
            this.addPropertiesInColumn((MarkupContainer)rightColumn, ObjectSpecifications.MemberGroupLayoutHint.RIGHT, columnSpans);
        } else {
            Components.permanentlyHide((MarkupContainer)this, ID_RIGHT_COLUMN);
        }
        if (columnSpans.getCollections() > 0) {
            int collectionSpan;
            String idCollectionsToHide;
            String idCollectionsToShow;
            if (columnSpans.exceedsRow()) {
                idCollectionsToShow = ID_ENTITY_COLLECTIONS_OVERFLOW;
                idCollectionsToHide = ID_ENTITY_COLLECTIONS;
                collectionSpan = 12;
            } else {
                idCollectionsToShow = ID_ENTITY_COLLECTIONS;
                idCollectionsToHide = ID_ENTITY_COLLECTIONS_OVERFLOW;
                collectionSpan = columnSpans.getCollections();
            }
            Component collectionsColumn = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, idCollectionsToShow, ComponentType.ENTITY_COLLECTIONS, (IModel<?>)entityModel);
            EntityPropertiesForm.addClassForSpan(collectionsColumn, collectionSpan);
            Components.permanentlyHide((MarkupContainer)this, idCollectionsToHide);
        } else {
            Components.permanentlyHide((MarkupContainer)this, ID_ENTITY_COLLECTIONS);
            Components.permanentlyHide((MarkupContainer)this, ID_ENTITY_COLLECTIONS_OVERFLOW);
        }
    }

    private boolean addPropertiesInColumn(MarkupContainer markupContainer, ObjectSpecifications.MemberGroupLayoutHint hint, MemberGroupLayout.ColumnSpans columnSpans) {
        int span = hint.from(columnSpans);
        EntityModel entityModel = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        ObjectSpecification objSpec = adapter.getSpecification();
        List<ObjectAssociation> associations = this.visibleProperties(adapter, objSpec, Where.OBJECT_FORMS);
        RepeatingView memberGroupRv = new RepeatingView(ID_MEMBER_GROUP);
        markupContainer.add(new Component[]{memberGroupRv});
        Map associationsByGroup = ObjectAssociation.Util.groupByMemberOrderName(associations);
        List groupNames = ObjectSpecifications.orderByMemberGroups((ObjectSpecification)objSpec, associationsByGroup.keySet(), (ObjectSpecifications.MemberGroupLayoutHint)hint);
        for (String groupName : groupNames) {
            List associationsInGroup = (List)associationsByGroup.get(groupName);
            if (associationsInGroup == null) continue;
            WebMarkupContainer memberGroupRvContainer = new WebMarkupContainer(memberGroupRv.newChildId());
            memberGroupRv.add(new Component[]{memberGroupRvContainer});
            memberGroupRvContainer.add(new Component[]{new Label(ID_MEMBER_GROUP_NAME, groupName)});
            RepeatingView propertyRv = new RepeatingView(ID_PROPERTIES);
            memberGroupRvContainer.add(new Component[]{propertyRv});
            for (ObjectAssociation association : associationsInGroup) {
                UiHintPathSignificantWebMarkupContainer propertyRvContainer = new UiHintPathSignificantWebMarkupContainer(propertyRv.newChildId());
                propertyRv.add(new Component[]{propertyRvContainer});
                this.addPropertyToForm(entityModel, association, propertyRvContainer);
            }
        }
        EntityPropertiesForm.addClassForSpan((Component)markupContainer, span);
        return !groupNames.isEmpty();
    }

    private void addPropertyToForm(EntityModel entityModel, ObjectAssociation association, WebMarkupContainer container) {
        OneToOneAssociation otoa = (OneToOneAssociation)association;
        PropertyMemento pm = new PropertyMemento(otoa);
        ScalarModel scalarModel = entityModel.getPropertyModel(pm);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ID_PROPERTY, ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarModel);
        if (!this.renderedFirstField) {
            component.add(new Behavior[]{new CssClassAppender("first-field")});
            this.renderedFirstField = true;
        }
    }

    private List<ObjectAssociation> visibleProperties(ObjectAdapter adapter, ObjectSpecification objSpec, Where where) {
        return objSpec.getAssociations(Contributed.INCLUDED, this.visiblePropertyFilter(adapter, where));
    }

    private Filter<ObjectAssociation> visiblePropertyFilter(ObjectAdapter adapter, Where where) {
        return Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.PROPERTIES, ObjectAssociation.Filters.dynamicallyVisible((AuthenticationSession)this.getAuthenticationSession(), (ObjectAdapter)adapter, (Where)where)});
    }

    private void addButtons(MarkupContainer markupContainer) {
        this.editButton = new AjaxButton(ID_EDIT_BUTTON, (IModel)Model.of((Serializable)((Object)"Edit"))){
            private static final long serialVersionUID = 1L;

            public void validate() {
                try {
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.CHECK);
                }
                catch (ConcurrencyException ex) {
                    EntityPropertiesForm.this.getMessageBroker().addMessage("Object changed by " + ex.getOid().getVersion().getUser() + ", automatically reloading");
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.NO_CHECK);
                }
                super.validate();
            }

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                EntityPropertiesForm.this.getEntityModel().resetPropertyModels();
                EntityPropertiesForm.this.toEditMode(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                EntityPropertiesForm.this.toEditMode(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                    private static final long serialVersionUID = 1L;

                    public CharSequence getSuccessHandler(Component component) {
                        return "$('.first-field input').focus();";
                    }
                });
            }
        };
        markupContainer.add(new Component[]{this.editButton});
        this.okButton = new ButtonWithPreValidateHook(ID_OK_BUTTON, (IModel)Model.of((Serializable)((Object)"OK"))){
            private static final long serialVersionUID = 1L;

            @Override
            public String preValidate() {
                try {
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.CHECK);
                }
                catch (ConcurrencyException ex) {
                    String recognizedErrorMessage = EntityPropertiesForm.this.recognizeException((RuntimeException)((Object)ex));
                    if (recognizedErrorMessage == null) {
                        throw ex;
                    }
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.NO_CHECK);
                    this.getForm().clearInput();
                    EntityPropertiesForm.this.getEntityModel().resetPropertyModels();
                    EntityPropertiesForm.this.toViewMode(null);
                    EntityPropertiesForm.this.toEditMode(null);
                    return recognizedErrorMessage;
                }
                return null;
            }

            public void validate() {
                EntityPropertiesForm form = EntityPropertiesForm.this;
                String preValidationErrorIfAny = form.getPreValidationErrorIfAny();
                if (preValidationErrorIfAny != null) {
                    EntityPropertiesForm.this.feedbackOrNotifyAnyRecognizedError(preValidationErrorIfAny, (Component)form);
                    EntityPage entityPage = new EntityPage((ObjectAdapter)EntityPropertiesForm.this.getModelObject(), null);
                    EntityPropertiesForm.this.setResponsePage((Page)entityPage);
                } else {
                    super.validate();
                }
            }

            public void onSubmit() {
                if (this.getForm().hasError()) {
                    return;
                }
                ObjectAdapter object = (ObjectAdapter)EntityPropertiesForm.this.getEntityModel().getObject();
                Memento snapshotToRollbackToIfInvalid = new Memento(object);
                EntityPropertiesForm.this.getEntityModel().apply();
                String invalidReasonIfAny = EntityPropertiesForm.this.getEntityModel().getReasonInvalidIfAny();
                if (invalidReasonIfAny != null) {
                    this.getForm().error((Serializable)((Object)invalidReasonIfAny));
                    snapshotToRollbackToIfInvalid.recreateObject();
                    EntityPropertiesForm.this.toEditMode(null);
                    return;
                }
                try {
                    EntityPropertiesForm.this.getTransactionManager().flushTransaction();
                }
                catch (RuntimeException ex) {
                    String message = EntityPropertiesForm.this.recognizeExceptionAndNotify(ex, (Component)EntityPropertiesForm.this);
                    if (message == null) {
                        throw ex;
                    }
                    EntityPropertiesForm.this.toEditMode(null);
                    return;
                }
                EntityPropertiesForm.this.getEntityModel().resetPropertyModels();
                EntityPropertiesForm.this.toViewMode(null);
                EntityPage entityPage = new EntityPage((ObjectAdapter)EntityPropertiesForm.this.getModelObject(), null);
                EntityPropertiesForm.this.setResponsePage((Page)entityPage);
            }
        };
        markupContainer.add(new Component[]{this.okButton});
        this.cancelButton = new AjaxButton(ID_CANCEL_BUTTON, (IModel)Model.of((Serializable)((Object)"Cancel"))){
            private static final long serialVersionUID = 1L;
            {
                this.setDefaultFormProcessing(false);
            }

            public void validate() {
                try {
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.CHECK);
                }
                catch (ConcurrencyException ex) {
                    EntityPropertiesForm.this.getMessageBroker().addMessage("Object changed by " + ex.getOid().getVersion().getUser() + ", automatically reloading");
                    EntityPropertiesForm.this.getEntityModel().load(AdapterManager.ConcurrencyChecking.NO_CHECK);
                }
                super.validate();
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Session.get().getFeedbackMessages().clear();
                this.getForm().clearInput();
                this.getForm().visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

                    public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                        if (formComponent instanceof CancelHintRequired) {
                            CancelHintRequired cancelHintRequired = (CancelHintRequired)formComponent;
                            cancelHintRequired.onCancel();
                        }
                    }
                });
                EntityPropertiesForm.this.getEntityModel().resetPropertyModels();
                EntityPropertiesForm.this.toViewMode(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                EntityPropertiesForm.this.toViewMode(target);
            }
        };
        markupContainer.add(new Component[]{this.cancelButton});
        this.okButton.setOutputMarkupPlaceholderTag(true);
        this.editButton.setOutputMarkupPlaceholderTag(true);
        this.cancelButton.setOutputMarkupPlaceholderTag(true);
        this.okButton.add(new Behavior[]{new JGrowlBehaviour()});
        this.editButton.add(new Behavior[]{new JGrowlBehaviour()});
        this.cancelButton.add(new Behavior[]{new JGrowlBehaviour()});
    }

    private String recognizeExceptionAndNotify(RuntimeException ex, Component feedbackComponentIfAny) {
        String recognizedErrorMessageIfAny = this.recognizeException(ex);
        this.feedbackOrNotifyAnyRecognizedError(recognizedErrorMessageIfAny, feedbackComponentIfAny);
        return recognizedErrorMessageIfAny;
    }

    private void feedbackOrNotifyAnyRecognizedError(String recognizedErrorMessageIfAny, Component feedbackComponentIfAny) {
        if (recognizedErrorMessageIfAny == null) {
            return;
        }
        if (feedbackComponentIfAny != null) {
            feedbackComponentIfAny.error((Serializable)((Object)recognizedErrorMessageIfAny));
        }
        this.getMessageBroker().addWarning(recognizedErrorMessageIfAny);
        this.getTransactionManager().getTransaction().clearAbortCause();
    }

    private String recognizeException(RuntimeException ex) {
        List exceptionRecognizers = this.getServicesInjector().lookupServices(ExceptionRecognizer.class);
        String message = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
        return message;
    }

    private void requestRepaintPanel(AjaxRequestTarget target) {
        if (target != null) {
            target.add(new Component[]{this.owningPanel});
            target.add(new Component[]{this.editButton, this.okButton, this.cancelButton, this.feedback});
        }
    }

    private EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    void toViewMode(AjaxRequestTarget target) {
        this.getEntityModel().toViewMode();
        if (this.editButton != null) {
            this.editButton.setVisible(this.isAnythingEditable());
        }
        if (this.okButton != null) {
            this.okButton.setVisible(false);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(false);
        }
        this.requestRepaintPanel(target);
    }

    private boolean isAnythingEditable() {
        EntityModel entityModel = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        return !this.enabledAssociations(adapter, adapter.getSpecification()).isEmpty();
    }

    private List<ObjectAssociation> enabledAssociations(ObjectAdapter adapter, ObjectSpecification objSpec) {
        return objSpec.getAssociations(Contributed.EXCLUDED, this.enabledAssociationFilter(adapter));
    }

    private Filter<ObjectAssociation> enabledAssociationFilter(ObjectAdapter adapter) {
        return Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.PROPERTIES, ObjectAssociation.Filters.enabled((AuthenticationSession)this.getAuthenticationSession(), (ObjectAdapter)adapter, (Where)Where.OBJECT_FORMS)});
    }

    private void toEditMode(AjaxRequestTarget target) {
        this.getEntityModel().toEditMode();
        this.editButton.setVisible(false);
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.requestRepaintPanel(target);
    }

    private void addFeedbackGui(MarkupContainer markupContainer) {
        this.feedback = new ComponentFeedbackPanel(ID_FEEDBACK, (Component)this);
        this.feedback.setOutputMarkupPlaceholderTag(true);
        markupContainer.addOrReplace(new Component[]{this.feedback});
        this.feedback.setEscapeModelStrings(false);
        ObjectAdapter adapter = (ObjectAdapter)this.getEntityModel().getObject();
        if (adapter == null) {
            this.feedback.error((Serializable)((Object)("cannot locate object:" + this.getEntityModel().getObjectAdapterMemento().toString())));
        }
    }

    private static void addClassForSpan(Component component, int numGridCols) {
        component.add(new Behavior[]{new CssClassAppender("span" + numGridCols)});
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }

    protected ServicesInjector getServicesInjector() {
        return IsisContext.getPersistenceSession().getServicesInjector();
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }
}

