/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.additionallinks.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.additionallinks.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ScalarPanelAbstract
extends PanelAbstract<ScalarModel>
implements TextFieldValueModel.ScalarModelProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_FEEDBACK = "feedback";
    protected Component componentIfCompact;
    private Component componentIfRegular;
    protected final ScalarModel scalarModel;
    private final List<ScalarModelSubscriber> subscribers = Lists.newArrayList();

    public ScalarPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.scalarModel = scalarModel;
    }

    protected Rendering getRendering() {
        return Rendering.renderingFor(((ScalarModel)this.getModel()).getRenderingHint());
    }

    protected Component getLabelForCompact() {
        return this.componentIfCompact;
    }

    public Component getComponentForRegular() {
        return this.componentIfRegular;
    }

    protected void onBeforeRender() {
        ScalarModel scalarModel;
        if (!this.hasBeenRendered() || this.alwaysRebuildGui()) {
            this.buildGui();
        }
        if ((scalarModel = (ScalarModel)this.getModel()).isViewMode()) {
            this.onBeforeRenderWhenViewMode();
        } else {
            String disableReasonIfAny = scalarModel.disable(this.getRendering().getWhere());
            if (disableReasonIfAny != null) {
                this.onBeforeRenderWhenDisabled(disableReasonIfAny);
            } else {
                this.onBeforeRenderWhenEnabled();
            }
        }
        super.onBeforeRender();
    }

    protected boolean alwaysRebuildGui() {
        return false;
    }

    private void buildGui() {
        this.componentIfCompact = this.addComponentForCompact();
        this.componentIfRegular = this.addComponentForRegular();
        this.getRendering().buildGui(this);
        this.addCssForMetaModel();
        if (!this.subscribers.isEmpty()) {
            this.addFormComponentBehavior((Behavior)new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    for (ScalarModelSubscriber subscriber : ScalarPanelAbstract.this.subscribers) {
                        subscriber.onUpdate(target, ScalarPanelAbstract.this);
                    }
                }

                protected void onError(AjaxRequestTarget target, RuntimeException e) {
                    super.onError(target, e);
                    for (ScalarModelSubscriber subscriber : ScalarPanelAbstract.this.subscribers) {
                        subscriber.onError(target, ScalarPanelAbstract.this);
                    }
                }
            });
        }
    }

    protected abstract void addFormComponentBehavior(Behavior var1);

    private void addCssForMetaModel() {
        ScalarModel model;
        CssClassFacet facet;
        String cssForMetaModel = ((ScalarModel)this.getModel()).getLongName();
        if (cssForMetaModel != null) {
            this.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)cssForMetaModel)), " ")});
        }
        if ((facet = (CssClassFacet)(model = (ScalarModel)this.getModel()).getFacet(CssClassFacet.class)) != null) {
            this.add(new Behavior[]{new CssClassAppender(facet.value())});
        }
    }

    protected abstract FormComponentLabel addComponentForRegular();

    protected abstract Component addComponentForCompact();

    protected void addFeedbackTo(MarkupContainer markupContainer, Component component) {
        markupContainer.addOrReplace(new Component[]{new ComponentFeedbackPanel(ID_FEEDBACK, component)});
    }

    protected void addAdditionalLinksTo(FormComponentLabel labelIfRegular) {
        List<LinkAndLabel> entityActions;
        if (this.scalarModel.getKind() == ScalarModel.Kind.PROPERTY) {
            ObjectAdapterMemento parentMemento = this.scalarModel.getParentObjectAdapterMemento();
            EntityModel parentEntityModel = new EntityModel(parentMemento);
            ActionPromptProvider provider = ActionPromptProvider.Util.getFrom((Component)this);
            entityActions = EntityActionUtil.entityActions(parentEntityModel, (ObjectAssociation)this.scalarModel.getPropertyMemento().getProperty(), provider);
        } else {
            entityActions = null;
        }
        this.addAdditionalLinks((MarkupContainer)labelIfRegular, entityActions);
    }

    private void addAdditionalLinks(MarkupContainer markupContainer, List<LinkAndLabel> links) {
        if (links == null || links.isEmpty()) {
            Components.permanentlyHide(markupContainer, ID_ADDITIONAL_LINKS);
            return;
        }
        links = Lists.newArrayList(links);
        AdditionalLinksPanel views = new AdditionalLinksPanel(ID_ADDITIONAL_LINKS, links);
        markupContainer.addOrReplace(new Component[]{views});
    }

    protected void onBeforeRenderWhenViewMode() {
    }

    protected void onBeforeRenderWhenDisabled(String disableReason) {
    }

    protected void onBeforeRenderWhenEnabled() {
    }

    public void notifyOnChange(ScalarModelSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public boolean updateChoices(ObjectAdapter[] pendingArguments) {
        return false;
    }

    public static enum Rendering {
        COMPACT{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return "";
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.getComponentForRegular().setVisible(false);
            }

            @Override
            public Where getWhere() {
                return Where.PARENTED_TABLES;
            }
        }
        ,
        REGULAR{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return (String)labeledContainer.getLabel().getObject();
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.getLabelForCompact().setVisible(false);
            }

            @Override
            public Where getWhere() {
                return Where.OBJECT_FORMS;
            }
        };


        public abstract String getLabelCaption(LabeledWebMarkupContainer var1);

        public abstract void buildGui(ScalarPanelAbstract var1);

        public abstract Where getWhere();

        private static Rendering renderingFor(EntityModel.RenderingHint renderingHint) {
            return renderingHint.isInTable() ? COMPACT : REGULAR;
        }
    }
}

