/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.typicallen.TypicalLengthFacet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ScalarPanelTextFieldAbstract<T extends Serializable>
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_NAME = "scalarName";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    protected final Class<T> cls;
    private AbstractTextComponent<T> textField;

    public ScalarPanelTextFieldAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel);
        this.cls = cls;
    }

    protected AbstractTextComponent<T> getTextField() {
        return this.textField;
    }

    protected AbstractTextComponent<T> createTextFieldForRegular() {
        return this.createTextField(ID_SCALAR_VALUE);
    }

    protected TextField<T> createTextField(String id) {
        return new TextField(id, this.newTextFieldValueModel(), this.cls);
    }

    protected TextFieldValueModel<T> newTextFieldValueModel() {
        return new TextFieldValueModel(this);
    }

    @Override
    protected FormComponentLabel addComponentForRegular() {
        String describedAs;
        this.textField = this.createTextFieldForRegular();
        this.textField.setOutputMarkupId(true);
        this.addStandardSemantics();
        this.addSemantics();
        FormComponentLabel labelIfRegular = this.createFormComponentLabel();
        this.addOrReplace(new Component[]{labelIfRegular});
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        if ((describedAs = ((ScalarModel)this.getModel()).getDescribedAs()) != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.textField);
        this.addAdditionalLinksTo(labelIfRegular);
        return labelIfRegular;
    }

    protected void addSemantics() {
    }

    private FormComponentLabel createFormComponentLabel() {
        AbstractTextComponent<T> textField = this.getTextField();
        String name = ((ScalarModel)this.getModel()).getName();
        textField.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormComponentLabel scalarNameAndValue = new FormComponentLabel(ID_SCALAR_IF_REGULAR, textField);
        scalarNameAndValue.add(new Component[]{textField});
        Label scalarName = new Label(ID_SCALAR_NAME, this.getRendering().getLabelCaption((LabeledWebMarkupContainer)textField));
        scalarNameAndValue.add(new Component[]{scalarName});
        return scalarNameAndValue;
    }

    protected void addStandardSemantics() {
        this.textField.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.setTextFieldSizeAndMaxLengthIfSpecified(this.textField);
    }

    protected void setTextFieldSizeAndMaxLengthIfSpecified(AbstractTextComponent<T> textField) {
        Integer maxLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class);
        Integer typicalLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), TypicalLengthFacet.class);
        if (typicalLength != null && maxLength != null && typicalLength > maxLength) {
            typicalLength = maxLength;
        }
        if (typicalLength != null) {
            textField.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + typicalLength))))});
        }
        if (maxLength != null) {
            textField.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)((Object)("" + maxLength))))});
        }
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    @Override
    protected Component addComponentForCompact() {
        Label labelIfCompact = new Label(ID_SCALAR_IF_COMPACT, ((ScalarModel)this.getModel()).getObjectAsString());
        this.addOrReplace(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.textField.setEnabled(false);
        this.setTitleAttribute("");
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.textField.setEnabled(false);
        this.setTitleAttribute(disableReason);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.textField.setEnabled(true);
        this.setTitleAttribute("");
    }

    private void setTitleAttribute(String titleAttribute) {
        this.textField.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.textField.add(new Behavior[]{behavior});
    }
}

