/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldWithDatePicker;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public abstract class ScalarPanelTextFieldDatePickerAbstract<T extends Serializable>
extends ScalarPanelTextFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    private DateConverter<T> converter;
    @Inject
    private WicketViewerSettings settings;

    public ScalarPanelTextFieldDatePickerAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel, cls);
    }

    protected void init(DateConverter<T> converter) {
        this.converter = converter;
    }

    protected int getAdjustBy() {
        RenderedAdjustedFacet facet = (RenderedAdjustedFacet)((ScalarModel)this.getModel()).getFacet(RenderedAdjustedFacet.class);
        return facet != null ? facet.value() : 0;
    }

    @Override
    protected TextField<T> createTextField(String id) {
        return new TextFieldWithDatePicker(id, new TextFieldValueModel(this), this.cls, this.converter);
    }

    @Override
    protected void addSemantics() {
        super.addSemantics();
        this.addObjectAdapterValidator();
    }

    @Override
    protected Component addComponentForCompact() {
        TextField<T> textField = this.createTextField("scalarIfCompact");
        IModel model = textField.getModel();
        Serializable object = (Serializable)model.getObject();
        model.setObject((Object)object);
        textField.setEnabled(false);
        int lengthAdjust = this.getLengthAdjustHint() != null ? this.getLengthAdjustHint() : 1;
        String dateTimePattern = this.converter.getDateTimePattern(this.getLocale());
        int length = dateTimePattern.length() + lengthAdjust;
        textField.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + length))))});
        this.addOrReplace(new Component[]{textField});
        return textField;
    }

    protected Integer getLengthAdjustHint() {
        return null;
    }

    private void addObjectAdapterValidator() {
        AbstractTextComponent textField = this.getTextField();
        textField.add(new IValidator<T>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<T> validatable) {
                Serializable proposed = (Serializable)validatable.getValue();
                ObjectAdapter proposedAdapter = ScalarPanelTextFieldDatePickerAbstract.this.adapterFor(proposed);
                String reasonIfAny = ScalarPanelTextFieldDatePickerAbstract.this.scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
    }

    protected String getDatePattern() {
        return this.converter.getDatePattern(this.getLocale());
    }

    protected String getDateTimePattern() {
        return this.converter.getDateTimePattern(this.getLocale());
    }

    protected String getDatePickerPattern() {
        return this.converter.getDatePickerPattern(this.getLocale());
    }

    protected WicketViewerSettings getSettings() {
        return this.settings;
    }

    private ObjectAdapter adapterFor(Object pojo) {
        return this.getAdapterManager().adapterFor(pojo);
    }
}

