/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxPostBehavior;
import com.googlecode.wicket.jquery.ui.form.datepicker.DatePickerBehavior;
import java.io.Serializable;
import java.util.Locale;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class TextFieldWithDatePicker<T>
extends TextField<T>
implements IConverter<T>,
IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private final DateConverter<T> converter;
    private final Options options;

    public TextFieldWithDatePicker(String id, IModel<T> model, Class<T> type, DateConverter<T> converter) {
        super(id, model, type);
        this.converter = converter;
        this.options = new Options();
        String datePickerPattern = converter.getDatePickerPattern(this.getLocale());
        this.options.set("dateFormat", (Serializable)((Object)("\"" + datePickerPattern + "\"")));
        this.options.set("changeMonth", (Serializable)Boolean.valueOf(true));
        this.options.set("changeYear", (Serializable)Boolean.valueOf(true));
        this.options.set("showButtonPanel", (Serializable)Boolean.valueOf(true));
        this.options.set("numberOfMonths", (Serializable)Integer.valueOf(3));
        this.options.set("showWeek", (Serializable)Boolean.valueOf(true));
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public boolean isOnSelectEventEnabled() {
        return true;
    }

    public void onSelect(AjaxRequestTarget target, String date) {
    }

    public T convertToObject(String value, Locale locale) {
        return (T)this.converter.convertToObject(value, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.converter.convertToString(value, locale);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (this.converter.getConvertableClass().isAssignableFrom(type)) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    protected void onInitialize() {
        super.onInitialize();
        JQueryBehavior newWidgetBehavior = IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{newWidgetBehavior});
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        DatePickerBehavior datePickerBehavior = new DatePickerBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public boolean isOnSelectEventEnabled() {
                return TextFieldWithDatePicker.this.isOnSelectEventEnabled();
            }

            public void onConfigure(Component component) {
                super.onConfigure(component);
                TextFieldWithDatePicker.this.onConfigure((JQueryBehavior)this);
            }

            public void onSelect(AjaxRequestTarget target, String date) {
                TextFieldWithDatePicker.this.onSelect(target, date);
            }

            protected JQueryAjaxPostBehavior newOnSelectBehavior() {
                return new JQueryAjaxPostBehavior((IJQueryAjaxAware)this, new FormComponent[]{TextFieldWithDatePicker.this}){
                    private static final long serialVersionUID = 1L;

                    protected CallbackParameter[] getCallbackParameters() {
                        return new CallbackParameter[]{CallbackParameter.explicit((String)"dateText"), CallbackParameter.context((String)"inst")};
                    }

                    protected JQueryEvent newEvent() {
                        return new DatePickerBehavior.SelectEvent();
                    }
                };
            }
        };
        return datePickerBehavior;
    }
}

