/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.activation.MimeType;
import javax.imageio.ImageIO;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.core.commons.lang.CloseableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.image.resource.ThumbnailImageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.BufferedDynamicImageResource;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsisBlobOrClobPanelAbstract<T extends NamedWithMimeType>
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IsisBlobOrClobPanelAbstract.class);
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_IF_REGULAR_DOWNLOAD = "scalarIfRegularDownload";
    private static final String ID_FILE_NAME = "fileName";
    private static final String ID_SCALAR_IF_REGULAR_CLEAR = "scalarIfRegularClear";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_IMAGE = "scalarImage";
    private static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private static final String ID_SCALAR_IF_COMPACT_DOWNLOAD = "scalarIfCompactDownload";
    private Image wicketImage;
    private FileUploadField fileUploadField;
    private Label fileNameLabel;

    @Override
    protected FormComponentLabel addComponentForRegular() {
        this.fileUploadField = this.createFileUploadField(ID_SCALAR_VALUE);
        this.fileUploadField.setLabel((IModel)Model.of((Serializable)((Object)((ScalarModel)this.getModel()).getName())));
        FormComponentLabel labelIfRegular = new FormComponentLabel(ID_SCALAR_IF_REGULAR, (LabeledWebMarkupContainer)this.fileUploadField);
        labelIfRegular.add(new Component[]{this.fileUploadField});
        Label scalarName = new Label(ID_SCALAR_NAME, ((ScalarModel)this.getModel()).getName());
        labelIfRegular.add(new Component[]{scalarName});
        this.wicketImage = this.asWicketImage(ID_IMAGE);
        if (this.wicketImage != null) {
            this.wicketImage.setOutputMarkupId(true);
            labelIfRegular.addOrReplace(new Component[]{this.wicketImage});
        } else {
            Components.permanentlyHide((MarkupContainer)labelIfRegular, ID_IMAGE);
        }
        this.updateFileNameLabel(ID_FILE_NAME, (MarkupContainer)labelIfRegular);
        this.updateDownloadLink(ID_SCALAR_IF_REGULAR_DOWNLOAD, (MarkupContainer)labelIfRegular);
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.fileUploadField);
        this.addAdditionalLinksTo(labelIfRegular);
        return labelIfRegular;
    }

    private Image asWicketImage(String id) {
        ObjectAdapter adapter = (ObjectAdapter)((ScalarModel)this.getModel()).getObject();
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (!(object instanceof Blob)) {
            return null;
        }
        Blob blob = (Blob)object;
        MimeType mimeType = blob.getMimeType();
        if (mimeType == null || !mimeType.getPrimaryType().equals("image")) {
            return null;
        }
        BufferedImage image = this.asBufferedImage(blob);
        if (image == null) {
            return null;
        }
        BufferedDynamicImageResource imageResource = new BufferedDynamicImageResource();
        imageResource.setImage(image);
        ThumbnailImageResource thumbnailImageResource = new ThumbnailImageResource((IResource)imageResource, 300);
        NonCachingImage wicketImage = new NonCachingImage(id, (IResource)thumbnailImageResource);
        return wicketImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage asBufferedImage(Blob blob) {
        byte[] bytes = blob.getBytes();
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            BufferedImage bufferedImage = ImageIO.read(bais);
            return bufferedImage;
        }
        catch (IOException ex) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            CloseableExtensions.closeSafely((Closeable)bais);
        }
    }

    @Override
    protected Component addComponentForCompact() {
        WebMarkupContainer scalarIfCompact = new WebMarkupContainer(ID_SCALAR_IF_COMPACT);
        MarkupContainer downloadLink = this.updateDownloadLink(ID_SCALAR_IF_COMPACT_DOWNLOAD, (MarkupContainer)scalarIfCompact);
        if (downloadLink != null) {
            this.updateFileNameLabel("fileNameIfCompact", downloadLink);
        }
        this.addOrReplace(new Component[]{scalarIfCompact});
        return scalarIfCompact;
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        this.updateRegularFormComponents(InputFieldVisibility.NOT_VISIBLE);
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        this.updateRegularFormComponents(InputFieldVisibility.NOT_VISIBLE);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE);
    }

    private FileUploadField createFileUploadField(String componentId) {
        FileUploadField fileUploadField = new FileUploadField(componentId, (IModel)new IModel<List<FileUpload>>(){
            private static final long serialVersionUID = 1L;

            public void setObject(List<FileUpload> fileUploads) {
                if (fileUploads == null || fileUploads.isEmpty()) {
                    return;
                }
                Object blob = IsisBlobOrClobPanelAbstract.this.getBlobOrClobFrom(fileUploads);
                ObjectAdapter adapter = IsisBlobOrClobPanelAbstract.this.getAdapterManager().adapterFor(blob);
                ((ScalarModel)IsisBlobOrClobPanelAbstract.this.getModel()).setObject(adapter);
            }

            public void detach() {
            }

            public List<FileUpload> getObject() {
                return null;
            }
        });
        return fileUploadField;
    }

    protected abstract T getBlobOrClobFrom(List<FileUpload> var1);

    private T getBlobOrClob(ScalarModel model) {
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        return (T)(adapter != null ? (NamedWithMimeType)adapter.getObject() : null);
    }

    public IsisBlobOrClobPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    private void updateRegularFormComponents(InputFieldVisibility visibility) {
        MarkupContainer formComponent = (MarkupContainer)this.getComponentForRegular();
        formComponent.get(ID_SCALAR_VALUE).setVisible(visibility == InputFieldVisibility.VISIBLE);
        this.fileNameLabel = this.updateFileNameLabel(ID_FILE_NAME, formComponent);
        this.updateClearLink(visibility);
        MarkupContainer downloadLink = this.updateDownloadLink(ID_SCALAR_IF_REGULAR_DOWNLOAD, formComponent);
        if (downloadLink != null) {
            downloadLink.setVisible(visibility == InputFieldVisibility.NOT_VISIBLE);
        }
        if (this.wicketImage != null) {
            this.wicketImage.setVisible(visibility == InputFieldVisibility.NOT_VISIBLE);
        }
    }

    private Label updateFileNameLabel(String idFileName, MarkupContainer formComponent) {
        class FileNameModel
        extends Model<String> {
            private static final long serialVersionUID = 1L;

            FileNameModel() {
            }

            public String getObject() {
                NamedWithMimeType blobOrClob = IsisBlobOrClobPanelAbstract.this.getBlobOrClobFromModel();
                String fileName = blobOrClob != null ? blobOrClob.getName() : "";
                return fileName;
            }
        }
        Label fileNameLabel = new Label(idFileName, (IModel)new FileNameModel());
        formComponent.addOrReplace(new Component[]{fileNameLabel});
        fileNameLabel.setOutputMarkupId(true);
        return fileNameLabel;
    }

    private void updateClearLink(InputFieldVisibility visibility) {
        final MarkupContainer formComponent = (MarkupContainer)this.getComponentForRegular();
        formComponent.setOutputMarkupId(true);
        AjaxLink<Void> ajaxLink = new AjaxLink<Void>(ID_SCALAR_IF_REGULAR_CLEAR){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                this.setEnabled(false);
                ScalarModel model = (ScalarModel)IsisBlobOrClobPanelAbstract.this.getModel();
                model.setObject(null);
                target.add(new Component[]{formComponent});
                target.add(new Component[]{IsisBlobOrClobPanelAbstract.this.fileNameLabel});
            }
        };
        ajaxLink.setOutputMarkupId(true);
        formComponent.addOrReplace(new Component[]{ajaxLink});
        T blobOrClob = this.getBlobOrClobFromModel();
        formComponent.get(ID_SCALAR_IF_REGULAR_CLEAR).setVisible(blobOrClob != null && visibility == InputFieldVisibility.VISIBLE);
    }

    private MarkupContainer updateDownloadLink(String downloadId, MarkupContainer container) {
        ResourceLink<?> resourceLink = this.createResourceLink(downloadId);
        if (resourceLink != null) {
            container.addOrReplace(new Component[]{resourceLink});
        } else {
            Components.permanentlyHide(container, downloadId);
        }
        return resourceLink;
    }

    private ResourceLink<?> createResourceLink(String id) {
        T blob = this.getBlobOrClobFromModel();
        if (blob == null) {
            return null;
        }
        IResource bar = this.newResource(blob);
        return new ResourceLink(id, bar);
    }

    private T getBlobOrClobFromModel() {
        return this.getBlobOrClob((ScalarModel)this.getModel());
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.fileUploadField.add(new Behavior[]{behavior});
    }

    protected abstract IResource newResource(T var1);

    protected static enum InputFieldVisibility {
        VISIBLE,
        NOT_VISIBLE;

    }
}

