/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaAbstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJavaSqlTimestamp
extends DateConverterForJavaAbstract<Timestamp> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJavaSqlTimestamp(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getTimestampPattern(), settings.getDatePickerPattern(), adjustBy);
    }

    public DateConverterForJavaSqlTimestamp(String datePattern, String dateTimePattern, String datePickerPattern, int adjustBy) {
        super(Timestamp.class, datePattern, dateTimePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected Timestamp doConvertToObject(String value, Locale locale) throws ConversionException {
        Timestamp date = this.convert(value);
        Timestamp adjustedDate = DateConverterForJavaSqlTimestamp.addDays(date, 0 - this.adjustBy);
        return adjustedDate;
    }

    private Timestamp convert(String valueStr) {
        try {
            return new Timestamp(this.newSimpleDateFormatUsingDateTimePattern().parse(valueStr).getTime());
        }
        catch (ParseException ex) {
            try {
                return new Timestamp(this.newSimpleDateFormatUsingDatePattern().parse(valueStr).getTime());
            }
            catch (ParseException ex2) {
                throw new ConversionException("Value cannot be converted as a date/time", (Throwable)ex);
            }
        }
    }

    @Override
    protected String doConvertToString(Timestamp value, Locale locale) throws ConversionException {
        Timestamp adjustedDate = DateConverterForJavaSqlTimestamp.addDays(value, this.adjustBy);
        return this.newSimpleDateFormatUsingDateTimePattern().format(adjustedDate);
    }

    private static Timestamp addDays(Date value, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.add(5, days);
        Timestamp adjusted = new Timestamp(cal.getTime().getTime());
        return adjusted;
    }
}

