/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractNumberConverter;
import org.apache.wicket.util.convert.converter.BigDecimalConverter;

class BigDecimalConverterWithScale
extends BigDecimalConverter {
    private static final long serialVersionUID = 1L;
    private final Integer scale;

    static AbstractNumberConverter<BigDecimal> newThreadSafeConverter(Integer scale) {
        return new BigDecimalConverterWithScale(scale);
    }

    BigDecimalConverterWithScale(Integer scale) {
        this.scale = scale;
    }

    protected NumberFormat newNumberFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat numberFormat = super.getNumberFormat(locale);
        if (this.scale != null) {
            numberFormat.setMaximumFractionDigits(this.scale);
            numberFormat.setMinimumFractionDigits(this.scale);
        }
        return numberFormat;
    }

    public BigDecimal convertToObject(String valueStr, Locale locale) throws ConversionException {
        DecimalFormat numberFormat = (DecimalFormat)this.getNumberFormat(locale);
        char groupingSeparator = numberFormat.getDecimalFormatSymbols().getGroupingSeparator();
        if (valueStr.contains("" + groupingSeparator)) {
            throw new ConversionException("Thousands separator '" + groupingSeparator + "' is not allowed in input");
        }
        BigDecimal bd = super.convertToObject(valueStr, locale);
        if (this.scale != null) {
            if (bd.scale() > this.scale) {
                throw new ConversionException("No more than " + this.scale + " digits can be entered after the decimal place");
            }
            try {
                return bd != null ? bd.setScale(this.scale) : null;
            }
            catch (Exception ex) {
                throw new ConversionException("'" + valueStr + "' is not a valid decimal number.");
            }
        }
        return bd;
    }

    public IConverter<BigDecimal> forEditMode() {
        return this;
    }

    public IConverter<BigDecimal> forViewMode() {
        return new BigDecimalConverterWithScale(this.scale){
            private static final long serialVersionUID = 1L;

            public String convertToString(BigDecimal value, Locale locale) {
                NumberFormat fmt = BigDecimalConverterWithScale.this.getNumberFormat(locale);
                fmt.setGroupingUsed(true);
                return fmt.format(value);
            }
        };
    }
}

