/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.primitive;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanPanel
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private CheckBox checkBox;

    public BooleanPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected FormComponentLabel addComponentForRegular() {
        String describedAs;
        String name = ((ScalarModel)this.getModel()).getName();
        this.checkBox = this.createCheckBox(ID_SCALAR_VALUE);
        this.checkBox.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormComponentLabel labelIfRegular = new FormComponentLabel(ID_SCALAR_IF_REGULAR, (LabeledWebMarkupContainer)this.checkBox);
        labelIfRegular.add(new Component[]{this.checkBox});
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        if ((describedAs = ((ScalarModel)this.getModel()).getDescribedAs()) != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        Label scalarName = new Label(ID_SCALAR_NAME, this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.checkBox));
        labelIfRegular.add(new Component[]{scalarName});
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.checkBox);
        this.addAdditionalLinksTo(labelIfRegular);
        return labelIfRegular;
    }

    @Override
    protected Component addComponentForCompact() {
        CheckBox component = this.createCheckBox(ID_SCALAR_IF_COMPACT);
        this.addOrReplace(new Component[]{component});
        return component;
    }

    private CheckBox createCheckBox(String id) {
        CheckBox checkBox = new CheckBox(id, (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean getObject() {
                ScalarModel model = (ScalarModel)BooleanPanel.this.getModel();
                ObjectAdapter adapter = (ObjectAdapter)model.getObject();
                return adapter != null ? (Boolean)adapter.getObject() : false;
            }

            public void setObject(Boolean object) {
                ObjectAdapter adapter = BooleanPanel.this.getAdapterManager().adapterFor((Object)object);
                ((ScalarModel)BooleanPanel.this.getModel()).setObject(adapter);
            }
        });
        checkBox.setOutputMarkupId(true);
        checkBox.setEnabled(false);
        return checkBox;
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.checkBox.add(new Behavior[]{behavior});
    }
}

