/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.reference;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.entitylink.EntityLinkSelect2Panel;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class ReferencePanel
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private EntityLinkSelect2Panel entityLink;

    public ReferencePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.entityLink.setEnabled(true);
        this.entityLink.syncVisibilityAndUsability();
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.entityLink.setEnabled(true);
        this.entityLink.syncVisibilityAndUsability();
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        EntityModel entityLinkModel = (EntityModel)this.entityLink.getModel();
        entityLinkModel.toViewMode();
        this.setTitleAttribute(disableReason);
        this.entityLink.syncVisibilityAndUsability();
    }

    private void setTitleAttribute(String titleAttribute) {
        this.entityLink.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected FormComponentLabel addComponentForRegular() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getName();
        this.entityLink = (EntityLinkSelect2Panel)this.getComponentFactoryRegistry().createComponent(ComponentType.ENTITY_LINK, (IModel<?>)this.getModel());
        this.setOutputMarkupId(true);
        this.entityLink.setOutputMarkupId(true);
        this.entityLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormComponentLabel labelIfRegular = new FormComponentLabel(ID_SCALAR_IF_REGULAR, (LabeledWebMarkupContainer)this.entityLink);
        labelIfRegular.add(new Component[]{this.entityLink});
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        Label scalarName = new Label(ID_SCALAR_NAME, this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.entityLink));
        labelIfRegular.add(new Component[]{scalarName});
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.entityLink);
        this.addAdditionalLinksTo(labelIfRegular);
        this.addStandardSemantics();
        this.addSemantics();
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        return labelIfRegular;
    }

    protected void addStandardSemantics() {
        this.setRequiredIfSpecified();
    }

    private void setRequiredIfSpecified() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        boolean required = scalarModel.isRequired();
        this.entityLink.setRequired(required);
    }

    protected void addSemantics() {
        this.addObjectAdapterValidator();
    }

    private void addObjectAdapterValidator() {
        final ScalarModel scalarModel = (ScalarModel)this.getModel();
        this.entityLink.add((IValidator)new IValidator<ObjectAdapter>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<ObjectAdapter> validatable) {
                ObjectAdapter proposedAdapter = (ObjectAdapter)validatable.getValue();
                String reasonIfAny = scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
    }

    @Override
    protected Component addComponentForCompact() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getName();
        Component entityLinkComponent = this.getComponentFactoryRegistry().createComponent(ComponentType.ENTITY_LINK, (IModel<?>)this.getModel());
        this.entityLink = (EntityLinkSelect2Panel)entityLinkComponent;
        this.entityLink.setOutputMarkupId(true);
        this.entityLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormComponentLabel labelIfCompact = new FormComponentLabel(ID_SCALAR_IF_COMPACT, (LabeledWebMarkupContainer)this.entityLink);
        labelIfCompact.add(new Component[]{this.entityLink});
        this.addOrReplace(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.entityLink.addFormComponentBehavior(behavior);
    }

    @Override
    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        return this.entityLink.updateChoices(argsIfAvailable);
    }
}

