/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.string;

import java.io.Serializable;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.multiline.MultiLineFacet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldParseableAbstract;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MultiLineStringPanel
extends ScalarPanelTextFieldParseableAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_VALUE = "scalarValue";

    public MultiLineStringPanel(String id, ScalarModel scalarModel) {
        super(id, ID_SCALAR_VALUE, scalarModel);
    }

    @Override
    protected AbstractTextComponent<String> createTextFieldForRegular() {
        TextArea textField = new TextArea(this.idTextField, (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return ((ScalarModel)MultiLineStringPanel.this.getModel()).getObjectAsString();
            }

            public void setObject(String object) {
                if (object == null) {
                    ((ScalarModel)MultiLineStringPanel.this.getModel()).setObject(null);
                } else {
                    ((ScalarModel)MultiLineStringPanel.this.getModel()).setObjectAsString(object);
                }
            }
        });
        MultiLineFacet multiLineFacet = (MultiLineFacet)((ScalarModel)this.getModel()).getFacet(MultiLineFacet.class);
        this.setAttribute((TextArea<String>)textField, "rows", multiLineFacet.numberOfLines());
        Integer maxLength = MultiLineStringPanel.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class);
        if (maxLength != null) {
            this.setAttribute((TextArea<String>)textField, "maxlength", maxLength);
        }
        return textField;
    }

    private Component setAttribute(TextArea<String> textField, String attributeName, int i) {
        return textField.add(new Behavior[]{AttributeModifier.replace((String)attributeName, (Serializable)((Object)("" + i)))});
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    public int getNumberOfLines(ScalarModel scalarModel) {
        MultiLineFacet multiLineFacet = (MultiLineFacet)scalarModel.getFacet(MultiLineFacet.class);
        int numberOfLines = 1;
        if (multiLineFacet != null) {
            numberOfLines = multiLineFacet.numberOfLines();
        }
        return numberOfLines;
    }
}

