/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.Response;
import com.vaynberg.wicket.select2.TextChoiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;

public abstract class ObjectAdapterMementoProviderAbstract
extends TextChoiceProvider<ObjectAdapterMemento> {
    private static final long serialVersionUID = 1L;
    private static final String NULL_PLACEHOLDER = "$$_isis_null_$$";
    private static final String NULL_DISPLAY_TEXT = "";
    private final ScalarModel scalarModel;

    public ObjectAdapterMementoProviderAbstract(ScalarModel scalarModel) {
        this.scalarModel = scalarModel;
    }

    protected String getDisplayText(ObjectAdapterMemento choice) {
        return choice != null ? choice.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK).titleString(null) : NULL_DISPLAY_TEXT;
    }

    protected Object getId(ObjectAdapterMemento choice) {
        return choice != null ? choice.toString() : NULL_PLACEHOLDER;
    }

    public void query(String term, int page, Response<ObjectAdapterMemento> response) {
        ArrayList mementos = Lists.newArrayList(this.obtainMementos(term));
        if (!this.scalarModel.isRequired() && !mementos.contains(null)) {
            mementos.add(0, null);
        }
        response.addAll((Collection)mementos);
    }

    protected abstract List<ObjectAdapterMemento> obtainMementos(String var1);

    public Collection<ObjectAdapterMemento> toChoices(Collection<String> ids) {
        Function<String, ObjectAdapterMemento> function = new Function<String, ObjectAdapterMemento>(){

            public ObjectAdapterMemento apply(String input) {
                if (ObjectAdapterMementoProviderAbstract.NULL_PLACEHOLDER.equals(input)) {
                    return null;
                }
                RootOidDefault oid = RootOidDefault.deString((String)input, (OidMarshaller)ObjectAdapterMemento.getOidMarshaller());
                return ObjectAdapterMemento.createPersistent((RootOid)oid);
            }
        };
        return Collections2.transform(ids, (Function)function);
    }
}

