/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu;

import java.io.Serializable;
import java.net.URL;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.AjaxDeferredBehaviour;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class ActionLinkFactoryAbstract
implements ActionLinkFactory {
    private static final long serialVersionUID = 1L;

    public static void addTargetBlankIfActionReturnsUrl(AbstractLink link, ObjectAction action) {
        ObjectSpecification returnType = action.getReturnType();
        if (returnType != null && "java.net.URL".equals(returnType.getFullIdentifier())) {
            link.add(new Behavior[]{new AttributeAppender("target", (IModel)Model.of((Serializable)((Object)"_blank")))});
            link.add(new Behavior[]{new CssClassAppender("noVeil")});
        }
    }

    protected AbstractLink newLink(String linkId, ObjectAdapter objectAdapter, ObjectAction action, ActionPromptProvider actionPromptProvider) {
        final ActionPrompt actionPrompt = actionPromptProvider.getActionPrompt();
        if (actionPrompt != null) {
            final ActionModel actionModel = ActionModel.create((ObjectAdapter)objectAdapter, (ObjectAction)action);
            actionModel.setActionPrompt(actionPrompt);
            final AjaxDeferredBehaviour ajaxDeferredBehaviour = ActionLinkFactoryAbstract.determineDeferredBehaviour(action, actionModel);
            AjaxLink<Object> link = new AjaxLink<Object>(linkId){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (ajaxDeferredBehaviour != null) {
                        ajaxDeferredBehaviour.initiate(target);
                    } else {
                        ActionPanel actionPromptPanel = (ActionPanel)ActionLinkFactoryAbstract.this.getComponentFactoryRegistry().createComponent(ComponentType.ACTION_PROMPT, actionPrompt.getContentId(), (IModel<?>)actionModel);
                        actionPrompt.setPanel((Component)actionPromptPanel, target);
                        actionPromptPanel.setActionPrompt(actionPrompt);
                        actionPrompt.show(target);
                        target.focusComponent((Component)actionPromptPanel);
                    }
                }
            };
            if (ajaxDeferredBehaviour != null) {
                link.add(new Behavior[]{ajaxDeferredBehaviour});
            }
            link.add(new Behavior[]{new CssClassAppender("noVeil")});
            return link;
        }
        AdapterManager.ConcurrencyChecking concurrencyChecking = AdapterManager.ConcurrencyChecking.concurrencyCheckingFor((ActionSemantics.Of)action.getSemantics());
        PageParameters pageParameters = ActionModel.createPageParameters((ObjectAdapter)objectAdapter, (ObjectAction)action, (AdapterManager.ConcurrencyChecking)concurrencyChecking);
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ACTION_PROMPT);
        AbstractLink link = Links.newBookmarkablePageLink(linkId, pageParameters, pageClass);
        if (action.getParameterCount() == 0) {
            ActionLinkFactoryAbstract.addTargetBlankIfActionReturnsUrl(link, action);
        }
        return link;
    }

    private static AjaxDeferredBehaviour determineDeferredBehaviour(ObjectAction action, final ActionModel actionModel) {
        if (ActionLinkFactoryAbstract.isNoArgReturnTypeRedirect(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.NEW_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = ActionLinkFactoryAbstract.executeActionHandlingApplicationExceptions(actionModel);
                    Object value = resultAdapter.getObject();
                    return ActionModel.redirectHandler((Object)value);
                }
            };
        }
        if (ActionLinkFactoryAbstract.isNoArgReturnTypeDownload(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.SAME_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = ActionLinkFactoryAbstract.executeActionHandlingApplicationExceptions(actionModel);
                    Object value = resultAdapter.getObject();
                    return ActionModel.downloadHandler((Object)value);
                }
            };
        }
        return null;
    }

    private static boolean isNoArgReturnTypeRedirect(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && action.getReturnType().getCorrespondingClass() == URL.class;
    }

    private static boolean isNoArgReturnTypeDownload(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && (action.getReturnType().getCorrespondingClass() == Blob.class || action.getReturnType().getCorrespondingClass() == Clob.class);
    }

    private static ObjectAdapter executeActionHandlingApplicationExceptions(ActionModel actionModel) {
        try {
            return (ObjectAdapter)actionModel.getObject();
        }
        catch (RuntimeException ex) {
            RecoverableException appEx = ActionModel.getApplicationExceptionIfAny((Exception)ex);
            if (appEx != null) {
                IsisContext.getMessageBroker().setApplicationError(appEx.getMessage());
                return null;
            }
            throw ex;
        }
    }

    protected LinkAndLabel newLinkAndLabel(ObjectAction action, AbstractLink link, String disabledReasonIfAny) {
        String label = ObjectAction.Utils.nameFor((ObjectAction)action);
        boolean blobOrClob = CssMenuItem.returnsBlobOrClob(action);
        boolean prototype = CssMenuItem.isExplorationOrPrototype(action);
        String actionIdentifier = CssMenuItem.actionIdentifierFor(action);
        String cssClass = CssMenuItem.cssClassFor(action);
        return new LinkAndLabel(link, label, disabledReasonIfAny, blobOrClob, prototype, actionIdentifier, cssClass);
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)Application.get()).getComponentFactoryRegistry();
    }

    protected PageClassRegistry getPageClassRegistry() {
        return ((PageClassRegistryAccessor)Application.get()).getPageClassRegistry();
    }
}

