/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu;

import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseHandlingStrategy;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class AjaxDeferredBehaviour
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final OpenUrlStrategy openUrlStrategy;

    protected AjaxDeferredBehaviour(OpenUrlStrategy openUrlStrategy) {
        this.openUrlStrategy = openUrlStrategy;
    }

    public void initiate(AjaxRequestTarget target) {
        String url = this.getCallbackUrl().toString();
        url = ActionResultResponseHandlingStrategy.expanded(url);
        String func = this.openUrlStrategy.javascriptFor(this, url);
        String javascriptFor = "setTimeout(" + func + ", 100);";
        target.appendJavaScript((CharSequence)javascriptFor);
    }

    public void onRequest() {
        IRequestHandler handler = this.getRequestHandler();
        if (handler != null) {
            this.getComponent().getRequestCycle().scheduleRequestHandlerAfterCurrent(handler);
        }
    }

    protected abstract IRequestHandler getRequestHandler();

    public static enum OpenUrlStrategy {
        NEW_WINDOW{

            @Override
            public String javascriptFor(AjaxDeferredBehaviour deferredBehaviour, String url) {
                Url parsedUrl = Url.parse((CharSequence)url);
                RequestCycle requestCycle = deferredBehaviour.getComponent().getRequestCycle();
                UrlRenderer urlRenderer = requestCycle.getUrlRenderer();
                String fullUrl = urlRenderer.renderFullUrl(parsedUrl);
                return "function(){isisOpenInNewTab('" + fullUrl + "')}";
            }
        }
        ,
        SAME_WINDOW{

            @Override
            public String javascriptFor(AjaxDeferredBehaviour deferredBehaviour, String url) {
                return "\"window.location.href='" + url + "'\"";
            }
        };


        public abstract String javascriptFor(AjaxDeferredBehaviour var1, String var2);
    }
}

