/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.progmodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.progmodel.facets.actions.notcontributed.NotContributedFacet;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuPanel;

public class CssMenuBuilder {
    private final ObjectAdapterMemento adapterMemento;
    private final List<ObjectAdapter> serviceAdapters;
    private final List<ObjectAction> actions;
    private final ActionLinkFactory cssMenuLinkFactory;

    public CssMenuBuilder(ObjectAdapterMemento adapterMemento, List<ObjectAdapter> serviceAdapters, List<ObjectAction> actions, ActionLinkFactory cssMenuLinkFactory) {
        this.adapterMemento = adapterMemento;
        this.serviceAdapters = serviceAdapters;
        this.actions = actions;
        this.cssMenuLinkFactory = cssMenuLinkFactory;
    }

    public CssMenuBuilder(List<ObjectAction> actions, ActionLinkFactory cssMenuLinkFactory) {
        this(null, null, actions, cssMenuLinkFactory);
    }

    public CssMenuPanel buildPanel(String wicketId, String rootName, ActionPromptProvider actionPromptModalWindowProvider) {
        CssMenuItem findUsing = CssMenuItem.newMenuItem(rootName).build();
        this.addMenuItems(findUsing, this.actions, actionPromptModalWindowProvider);
        CssMenuPanel cssMenuPanel = new CssMenuPanel(wicketId, CssMenuPanel.Style.SMALL, Collections.singletonList(findUsing));
        return cssMenuPanel;
    }

    private void addMenuItems(CssMenuItem parent, List<ObjectAction> actions, ActionPromptProvider actionPromptModalWindowProvider) {
        this.addMenuItemsForActionsOfType(parent, actions, ActionType.USER, actionPromptModalWindowProvider);
        if (this.isExploring() || this.isPrototyping()) {
            this.addMenuItemsForActionsOfType(parent, actions, ActionType.EXPLORATION, actionPromptModalWindowProvider);
            this.addMenuItemsForActionsOfType(parent, actions, ActionType.PROTOTYPE, actionPromptModalWindowProvider);
        }
        if (this.isDebugMode()) {
            this.addMenuItemsForActionsOfType(parent, actions, ActionType.DEBUG, actionPromptModalWindowProvider);
        }
    }

    public boolean isExploring() {
        return IsisContext.getDeploymentType().isExploring();
    }

    public boolean isPrototyping() {
        return IsisContext.getDeploymentType().isPrototyping();
    }

    protected boolean isDebugMode() {
        return true;
    }

    private void addMenuItemsForActionsOfType(CssMenuItem parent, List<ObjectAction> actions, ActionType type, ActionPromptProvider actionPromptModalWindowProvider) {
        Collection filterActionsOfType = Collections2.filter(actions, (Predicate)Filters.asPredicate((Filter)ObjectAction.Filters.ofType((ActionType)type)));
        for (ObjectAction action : filterActionsOfType) {
            this.addMenuItem(parent, action, actionPromptModalWindowProvider);
        }
    }

    private void addMenuItem(CssMenuItem parent, ObjectAction action, ActionPromptProvider actionPromptModalWindowProvider) {
        this.addMenuItemForAction(parent, action, actionPromptModalWindowProvider);
    }

    private void addMenuItemForAction(CssMenuItem parent, ObjectAction action, ActionPromptProvider actionPromptModalWindowProvider) {
        NotContributedFacet notContributed = (NotContributedFacet)action.getFacet(NotContributedFacet.class);
        if (notContributed != null && notContributed.toActions()) {
            return;
        }
        CssMenuItem.Builder subMenuItemBuilder = null;
        ObjectAdapterMemento targetAdapterMemento = this.adapterMemento;
        if (targetAdapterMemento != null) {
            subMenuItemBuilder = parent.newSubMenuItem(targetAdapterMemento, action, this.cssMenuLinkFactory, actionPromptModalWindowProvider);
        } else if (action.containsDoOpFacet(BulkFacet.class)) {
            subMenuItemBuilder = parent.newSubMenuItem(action, this.cssMenuLinkFactory, actionPromptModalWindowProvider);
        }
        if (subMenuItemBuilder != null) {
            subMenuItemBuilder.build();
        }
    }

    protected List<ObjectAdapter> getServiceAdapters() {
        return this.serviceAdapters;
    }
}

