/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssSubMenuItemsPanel;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class CssMenuItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_MENU_LINK = "menuLink";
    private final String name;
    private final List<CssMenuItem> subMenuItems = Lists.newArrayList();
    private CssMenuItem parent;
    private AbstractLink link;
    private boolean enabled = true;
    private String disabledReason;
    private boolean blobOrClob = false;
    private boolean prototype = false;
    static final String ID_MENU_LABEL = "menuLabel";
    static final String ID_SUB_MENU_ITEMS = "subMenuItems";
    private String actionIdentifier;
    private String cssClass;
    private String description;
    private final Where where = Where.ANYWHERE;

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public static Builder newMenuItem(String name) {
        return new Builder(name);
    }

    public void setActionIdentifier(String actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    public void setPrototyping(boolean prototype) {
        this.prototype = prototype;
    }

    private CssMenuItem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    private void setParent(CssMenuItem parent) {
        this.parent = parent;
    }

    public Builder newSubMenuItem(String name) {
        return CssMenuItem.newMenuItem(name).parent(this);
    }

    public List<CssMenuItem> getSubMenuItems() {
        return Collections.unmodifiableList(this.subMenuItems);
    }

    public boolean hasSubMenuItems() {
        return this.subMenuItems.size() > 0;
    }

    public AbstractLink getLink() {
        return this.link;
    }

    private void setLink(AbstractLink link) {
        this.link = link;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReturnsBlobOrClob(boolean blobOrClob) {
        this.blobOrClob = blobOrClob;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Builder newSubMenuItem(ObjectAdapterMemento targetAdapterMemento, ObjectAction objectAction, ActionLinkFactory cssMenuLinkFactory, ActionPromptProvider actionPromptModalWindowProvider) {
        ObjectAdapter adapter;
        AuthenticationSession session = this.getAuthenticationSession();
        Consent visibility = objectAction.isVisible(session, adapter = targetAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK), this.where);
        if (visibility.isVetoed()) {
            return null;
        }
        LinkAndLabel linkAndLabel = cssMenuLinkFactory.newLink(targetAdapterMemento, objectAction, ID_MENU_LINK, actionPromptModalWindowProvider);
        if (linkAndLabel == null) {
            return null;
        }
        AbstractLink link = linkAndLabel.getLink();
        String actionLabel = linkAndLabel.getLabel();
        Consent usability = objectAction.isUsable(session, adapter, this.where);
        String reasonDisabledIfAny = usability.getReason();
        DescribedAsFacet describedAsFacet = (DescribedAsFacet)objectAction.getFacet(DescribedAsFacet.class);
        String descriptionIfAny = describedAsFacet != null ? describedAsFacet.value() : null;
        CssClassFacet cssClassFacet = (CssClassFacet)objectAction.getFacet(CssClassFacet.class);
        boolean blobOrClob = CssMenuItem.returnsBlobOrClob(objectAction);
        boolean prototype = CssMenuItem.isExplorationOrPrototype(objectAction);
        String actionIdentifier = CssMenuItem.actionIdentifierFor(objectAction);
        Builder builder = this.newSubMenuItem(actionLabel).link(link).describedAs(descriptionIfAny).enabled(reasonDisabledIfAny).returnsBlobOrClob(blobOrClob).prototyping(prototype).withActionIdentifier(actionIdentifier);
        if (cssClassFacet != null) {
            builder.withCssClass(cssClassFacet.value());
        }
        return builder;
    }

    public static boolean returnsBlobOrClob(ObjectAction objectAction) {
        Class cls;
        boolean blobOrClob = false;
        ObjectSpecification returnType = objectAction.getReturnType();
        if (returnType != null && (Blob.class.isAssignableFrom(cls = returnType.getCorrespondingClass()) || Clob.class.isAssignableFrom(cls))) {
            blobOrClob = true;
        }
        return blobOrClob;
    }

    public static boolean isExplorationOrPrototype(ObjectAction action) {
        return action.getType().isExploration() || action.getType().isPrototype();
    }

    public static String actionIdentifierFor(ObjectAction action) {
        Identifier identifier = action.getIdentifier();
        String className = action.getOnType().getShortIdentifier();
        String actionId = action.getId();
        return className + "-" + actionId;
    }

    public static String cssClassFor(ObjectAction action) {
        CssClassFacet cssClassFacet = (CssClassFacet)action.getFacet(CssClassFacet.class);
        return cssClassFacet != null ? cssClassFacet.value() : null;
    }

    public Builder newSubMenuItem(ObjectAction objectAction, ActionLinkFactory cssMenuLinkFactory, ActionPromptProvider actionPromptModalWindowProvider) {
        LinkAndLabel linkAndLabel = cssMenuLinkFactory.newLink(null, objectAction, ID_MENU_LINK, actionPromptModalWindowProvider);
        AbstractLink link = linkAndLabel.getLink();
        String actionLabel = linkAndLabel.getLabel();
        Builder builder = this.newSubMenuItem(actionLabel).link(link).prototyping(linkAndLabel.isPrototype()).returnsBlobOrClob(linkAndLabel.isBlobOrClob());
        CssClassFacet cssClassFacet = (CssClassFacet)objectAction.getFacet(CssClassFacet.class);
        if (cssClassFacet != null) {
            builder.withCssClass(cssClassFacet.value());
        }
        return builder;
    }

    void addTo(MarkupContainer markupContainer) {
        Component menuItemComponent = this.addMenuItemComponentTo(markupContainer);
        this.addSubMenuItemComponentsIfAnyTo(markupContainer);
        this.addCssClassAttributesIfRequired(menuItemComponent);
    }

    private Component addMenuItemComponentTo(MarkupContainer markupContainer) {
        AbstractLink link = this.getLink();
        Label label = new Label(ID_MENU_LABEL, (IModel)Model.of((Serializable)((Object)this.getName())));
        if (this.isEnabled() && link != null) {
            markupContainer.add(new Component[]{link});
            link.add(new Component[]{label});
            if (this.description != null) {
                label.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.description)))});
            }
            if (this.blobOrClob) {
                link.add(new Behavior[]{new CssClassAppender("noVeil")});
            }
            if (this.prototype) {
                link.add(new Behavior[]{new CssClassAppender("prototype")});
            }
            if (this.cssClass != null) {
                markupContainer.add(new Behavior[]{new CssClassAppender(this.cssClass)});
            }
            link.add(new Behavior[]{new CssClassAppender(this.actionIdentifier)});
            Components.permanentlyHide(markupContainer, ID_MENU_LABEL);
            return link;
        }
        Components.permanentlyHide(markupContainer, ID_MENU_LINK);
        label.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.getDisabledReason())))});
        label.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"disabled")))});
        markupContainer.add(new Component[]{label});
        return label;
    }

    private void addSubMenuItemComponentsIfAnyTo(MarkupContainer menuItemMarkup) {
        List<CssMenuItem> subMenuItems = this.getSubMenuItems();
        if (subMenuItems.isEmpty()) {
            Components.permanentlyHide(menuItemMarkup, ID_SUB_MENU_ITEMS);
        } else {
            menuItemMarkup.add(new Component[]{new CssSubMenuItemsPanel(ID_SUB_MENU_ITEMS, subMenuItems)});
        }
    }

    private void addCssClassAttributesIfRequired(Component linkComponent) {
        if (!this.hasSubMenuItems()) {
            return;
        }
        if (this.hasParent()) {
            linkComponent.add(new Behavior[]{new CssClassAppender("parent")});
        } else {
            linkComponent.add(new Behavior[]{new CssClassAppender("top-parent")});
        }
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    public static class Builder {
        private final CssMenuItem cssMenuItem;

        private Builder(String name) {
            this.cssMenuItem = new CssMenuItem(name);
        }

        public Builder parent(CssMenuItem parent) {
            this.cssMenuItem.setParent(parent);
            return this;
        }

        public <T extends Page> Builder link(Class<T> pageClass) {
            SubmitLink link = new SubmitLink(CssMenuItem.ID_MENU_LINK);
            return this.link((AbstractLink)link);
        }

        public <T extends Page> Builder link(AbstractLink link) {
            Ensure.ensureThatArg((Object)link.getId(), (Matcher)CoreMatchers.is((Object)CssMenuItem.ID_MENU_LINK));
            this.cssMenuItem.setLink(link);
            return this;
        }

        public <T extends Page> Builder enabled(String disabledReasonIfAny) {
            this.cssMenuItem.setEnabled(disabledReasonIfAny == null);
            this.cssMenuItem.setDisabledReason(disabledReasonIfAny);
            return this;
        }

        public Builder describedAs(String descriptionIfAny) {
            this.cssMenuItem.setDescription(descriptionIfAny);
            return this;
        }

        public Builder returnsBlobOrClob(boolean blobOrClob) {
            this.cssMenuItem.setReturnsBlobOrClob(blobOrClob);
            return this;
        }

        public CssMenuItem itemBeingBuilt() {
            return this.cssMenuItem;
        }

        public Builder prototyping(boolean prototype) {
            this.cssMenuItem.setPrototyping(prototype);
            return this;
        }

        public Builder withActionIdentifier(String actionIdentifier) {
            this.cssMenuItem.setActionIdentifier(actionIdentifier);
            return this;
        }

        public void withCssClass(String cssClass) {
            this.cssMenuItem.setCssClass(cssClass);
        }

        public CssMenuItem build() {
            if (this.cssMenuItem.parent != null) {
                this.cssMenuItem.parent.subMenuItems.add(this.cssMenuItem);
            }
            return this.cssMenuItem;
        }
    }
}

