/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu;

import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.widgets.cssmenu.CssMenuItemPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.util.ListModel;

public class CssMenuPanel
extends PanelAbstract<MyModel> {
    private static final long serialVersionUID = 1L;
    private final StyleAppender styleAppender;
    static final String ID_MENU_ITEMS = "menuItems";
    static final String ID_MENU_ITEM = "menuItem";

    public static CssMenuItem.Builder newMenuItem(String name) {
        return CssMenuItem.newMenuItem(name);
    }

    public CssMenuPanel(String id, Style style, List<CssMenuItem> topLevelMenuItems) {
        super(id, new MyModel(topLevelMenuItems));
        this.styleAppender = new StyleAppender(style);
        this.add(new Behavior[]{this.styleAppender});
        RepeatingView menuItemRv = new RepeatingView(ID_MENU_ITEMS);
        this.add(new Component[]{menuItemRv});
        for (CssMenuItem cssMenuItem : (List)((MyModel)((Object)this.getModel())).getObject()) {
            WebMarkupContainer menuItemMarkup = new WebMarkupContainer(menuItemRv.newChildId());
            menuItemRv.add(new Component[]{menuItemMarkup});
            menuItemMarkup.add(new Component[]{new CssMenuItemPanel(ID_MENU_ITEM, cssMenuItem)});
        }
    }

    public CssMenuPanel(ComponentType componentType, Style style, CssMenuItem ... topLevelMenuItems) {
        this(componentType.getWicketId(), style, Arrays.asList(topLevelMenuItems));
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        PanelUtil.renderHead(response, ((Object)((Object)this)).getClass());
    }

    static final class StyleAppender
    extends CssClassAppender {
        private static final long serialVersionUID = 1L;

        public StyleAppender(Style style) {
            super(style.getAppendValue());
        }
    }

    static class MyModel
    extends ListModel<CssMenuItem> {
        private static final long serialVersionUID = 1L;

        public MyModel(List<CssMenuItem> cssMenuItems) {
            super(cssMenuItems);
        }
    }

    public static enum Style {
        REGULAR{

            @Override
            public String getAppendValue() {
                return null;
            }
        }
        ,
        SMALL{

            @Override
            public String getAppendValue() {
                return this.toString();
            }
        };


        public String toString() {
            return StringExtensions.toCamelCase((String)this.name());
        }

        public String getAppendValue() {
            return this.toString();
        }
    }
}

