/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.entitylink;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Select2Choice;
import com.vaynberg.wicket.select2.Settings;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;
import org.apache.isis.viewer.wicket.model.util.MementoFunctions;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionInvokeHandler;
import org.apache.isis.viewer.wicket.ui.components.widgets.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.Select2ChoiceUtil;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.CancelHintRequired;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormComponentPanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityLinkSelect2Panel
extends FormComponentPanelAbstract<ObjectAdapter>
implements CancelHintRequired,
ActionInvokeHandler {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_ENTITY_ICON_AND_TITLE = "entityIconAndTitle";
    private Select2Choice<ObjectAdapterMemento> select2Field;
    private Link<String> entityDetailsLink;
    private Link<String> entityClearLink;

    public EntityLinkSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.setType(ObjectAdapter.class);
        this.buildGui();
    }

    public ScalarModel getScalarModel() {
        return (ScalarModel)this.getModel();
    }

    private void buildGui() {
        this.syncWithInput();
    }

    public boolean checkRequired() {
        if (this.select2Field != null) {
            return this.select2Field.checkRequired();
        }
        return super.checkRequired();
    }

    public boolean isRequired() {
        return super.isRequired();
    }

    public void syncVisibilityAndUsability() {
        boolean mutability;
        boolean bl = mutability = this.isEnableAllowed() && !this.getScalarModel().isViewMode();
        if (this.entityClearLink != null) {
            this.entityClearLink.setVisible(mutability);
        }
        if (this.entityDetailsLink != null) {
            this.entityDetailsLink.setVisible(this.getScalarModel().getRenderingHint() == EntityModel.RenderingHint.REGULAR);
        }
        if (this.select2Field != null) {
            this.select2Field.setEnabled(mutability);
        }
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        }
    }

    protected void doSyncVisibilityAndUsability(boolean mutability) {
        if (this.select2Field != null) {
            this.select2Field.setEnabled(mutability);
        }
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        }
    }

    public String getInput() {
        ObjectAdapter pendingElseCurrentAdapter = this.getScalarModel().getPendingElseCurrentAdapter();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.titleString(null) : "(no object)";
    }

    protected void convertInput() {
        if (this.getScalarModel().isEditMode() && this.isEditableWithEitherAutoCompleteOrChoices()) {
            this.onSelected((ObjectAdapterMemento)this.select2Field.getConvertedInput());
        }
        ObjectAdapter pendingAdapter = this.getScalarModel().getPendingAdapter();
        this.setConvertedInput(pendingAdapter);
    }

    protected void onBeforeRender() {
        this.syncWithInput();
        super.onBeforeRender();
    }

    private void syncWithInput() {
        ObjectAdapter adapter = this.getPendingElseCurrentAdapter();
        this.syncLinkWithInput(adapter);
        this.doSyncWithInputIfAutoCompleteOrChoices();
        this.syncVisibilityAndUsability();
    }

    private void doSyncWithInputIfAutoCompleteOrChoices() {
        if (!this.isEditableWithEitherAutoCompleteOrChoices()) {
            this.permanentlyHide(ID_AUTO_COMPLETE);
            this.select2Field = null;
            return;
        }
        Model model = ScalarModelWithPending.Util.createModel((ScalarModelWithPending)this.getScalarModel().asScalarModelWithPending());
        if (this.select2Field == null) {
            this.setRequired(this.getScalarModel().isRequired());
            this.select2Field = Select2ChoiceUtil.newSelect2Choice(ID_AUTO_COMPLETE, (IModel<ObjectAdapterMemento>)model, this.getScalarModel());
            this.setProviderAndCurrAndPending(this.select2Field, this.getScalarModel().getActionArgsHint());
            if (!this.getScalarModel().hasChoices()) {
                Settings settings = this.select2Field.getSettings();
                ScalarModel scalarModel = this.getScalarModel();
                int minLength = scalarModel.getAutoCompleteMinLength();
                settings.setMinimumInputLength(Integer.valueOf(minLength));
                settings.setPlaceholder((Object)scalarModel.getName());
            }
            this.addOrReplace(new Component[]{this.select2Field});
        } else {
            this.select2Field.clearInput();
        }
        this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
    }

    private ChoiceProvider<ObjectAdapterMemento> providerForObjectAutoComplete() {
        ScalarModel entityModel = this.getScalarModel();
        return new ObjectAdapterMementoProviderAbstract(this.getScalarModel(), (EntityModel)entityModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ EntityModel val$entityModel;
            {
                this.val$entityModel = entityModel;
                super(x0);
            }

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                ObjectSpecification typeOfSpecification = this.val$entityModel.getTypeOfSpecification();
                AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
                List results = autoCompleteFacet.execute(term);
                return Lists.transform((List)results, (Function)ObjectAdapterMemento.Functions.fromAdapter());
            }
        };
    }

    private ChoiceProvider<ObjectAdapterMemento> providerForParamOrPropertyAutoComplete() {
        ScalarModel entityModel = this.getScalarModel();
        return new ObjectAdapterMementoProviderAbstract(this.getScalarModel(), (EntityModel)entityModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ EntityModel val$entityModel;
            {
                this.val$entityModel = entityModel;
                super(x0);
            }

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                ArrayList autoCompleteChoices = Lists.newArrayList();
                ScalarModel scalarModel = (ScalarModel)this.val$entityModel;
                if (scalarModel.hasAutoComplete()) {
                    autoCompleteChoices.addAll(scalarModel.getAutoComplete(term));
                }
                return Lists.newArrayList((Iterable)Lists.transform((List)autoCompleteChoices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
            }
        };
    }

    private List<ObjectAdapterMemento> getChoiceMementos(ObjectAdapter[] argsIfAvailable) {
        ArrayList choices = Lists.newArrayList();
        ScalarModel scalarModel = this.getScalarModel();
        if (scalarModel.hasChoices()) {
            choices.addAll(scalarModel.getChoices(argsIfAvailable));
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)MementoFunctions.fromAdapter()));
    }

    private void syncLinkWithInput(ObjectAdapter adapter) {
        if (adapter != null) {
            this.addOrReplaceIconAndTitle(adapter);
        } else {
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        }
    }

    private void addOrReplaceIconAndTitle(ObjectAdapter pendingOrCurrentAdapter) {
        EntityModel entityModelForLink = new EntityModel(pendingOrCurrentAdapter);
        entityModelForLink.setContextAdapterIfAny(this.getScalarModel().getContextAdapterIfAny());
        entityModelForLink.setRenderingHint(this.getScalarModel().getRenderingHint());
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)entityModelForLink);
        Component component = componentFactory.createComponent((IModel<?>)entityModelForLink);
        this.addOrReplace(new Component[]{component});
    }

    @Override
    public void onClick(ActionModel actionModel) {
    }

    public void onSelected(ObjectAdapterMemento selectedAdapterMemento) {
        this.getScalarModel().setPending(selectedAdapterMemento);
        this.getScalarModel().setObject(selectedAdapterMemento != null ? selectedAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null);
        if (this.select2Field != null) {
            this.select2Field.getModel().setObject((Object)selectedAdapterMemento);
        }
    }

    public void onNoResults() {
        this.renderSamePage();
    }

    @Override
    public void onCancel() {
        this.getScalarModel().clearPending();
    }

    private ObjectAdapter getPendingElseCurrentAdapter() {
        return this.getScalarModel().getPendingElseCurrentAdapter();
    }

    private void renderSamePage() {
        this.setResponsePage(this.getPage());
    }

    private boolean isEditableWithEitherAutoCompleteOrChoices() {
        if (this.getScalarModel().getRenderingHint().isInTable()) {
            return false;
        }
        if (this.getScalarModel().isViewMode()) {
            return false;
        }
        return this.getScalarModel().hasChoices() || this.hasParamOrPropertyAutoComplete() || this.hasObjectAutoComplete();
    }

    private boolean hasParamOrPropertyAutoComplete() {
        return this.getScalarModel().hasAutoComplete();
    }

    private boolean hasObjectAutoComplete() {
        boolean hasAutoComplete = this.getScalarModel().hasAutoComplete();
        if (hasAutoComplete) {
            return true;
        }
        ObjectSpecification typeOfSpecification = this.getScalarModel().getTypeOfSpecification();
        AutoCompleteFacet autoCompleteFacet = typeOfSpecification != null ? (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class) : null;
        return autoCompleteFacet != null;
    }

    public void addFormComponentBehavior(Behavior behavior) {
        if (this.select2Field != null) {
            this.select2Field.add(new Behavior[]{behavior});
        }
    }

    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        if (this.select2Field != null) {
            this.setProviderAndCurrAndPending(this.select2Field, argsIfAvailable);
            return true;
        }
        return false;
    }

    private void setProviderAndCurrAndPending(Select2Choice<ObjectAdapterMemento> select2Field, ObjectAdapter[] argsIfAvailable) {
        if (this.getScalarModel().hasChoices()) {
            List<ObjectAdapterMemento> choiceMementos = this.getChoiceMementos(argsIfAvailable);
            select2Field.setProvider((ChoiceProvider)this.providerForChoices(choiceMementos));
            this.getScalarModel().clearPending();
            this.resetIfCurrentNotInChoices(select2Field, choiceMementos);
        } else if (this.hasParamOrPropertyAutoComplete()) {
            select2Field.setProvider(this.providerForParamOrPropertyAutoComplete());
            this.getScalarModel().clearPending();
        } else {
            select2Field.setProvider(this.providerForObjectAutoComplete());
            this.getScalarModel().clearPending();
        }
    }

    private ObjectAdapterMementoProviderAbstract providerForChoices(final List<ObjectAdapterMemento> choiceMementos) {
        return new ObjectAdapterMementoProviderAbstract(this.getScalarModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String unused) {
                return choiceMementos;
            }
        };
    }

    private void resetIfCurrentNotInChoices(Select2Choice<ObjectAdapterMemento> select2Field, List<ObjectAdapterMemento> choiceMementos) {
        ObjectAdapterMemento curr = (ObjectAdapterMemento)select2Field.getModelObject();
        if (curr == null) {
            select2Field.getModel().setObject(null);
            this.getModel().setObject(null);
            return;
        }
        if (!curr.containedIn(choiceMementos)) {
            if (!choiceMementos.isEmpty()) {
                ObjectAdapterMemento newAdapterMemento = choiceMementos.get(0);
                select2Field.getModel().setObject((Object)newAdapterMemento);
                this.getModel().setObject((Object)newAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK));
            } else {
                select2Field.getModel().setObject(null);
                this.getModel().setObject(null);
            }
        }
    }
}

