/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.valuechoices;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Select2Choice;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.Select2ChoiceUtil;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentLabel;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ValueChoicesSelect2Panel
extends ScalarPanelAbstract
implements ScalarModelWithPending {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_VALUE_ID = "valueId";
    private Select2Choice<ObjectAdapterMemento> select2Field;
    private ObjectAdapterMemento pending;

    public ValueChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.pending = scalarModel.getObjectAdapterMemento();
    }

    @Override
    protected FormComponentLabel addComponentForRegular() {
        Model modelObject = ScalarModelWithPending.Util.createModel((ScalarModelWithPending)this);
        ObjectAdapter[] actionArgsHint = this.getScalarModel().getActionArgsHint();
        if (this.select2Field == null) {
            this.select2Field = Select2ChoiceUtil.newSelect2Choice(ID_VALUE_ID, (IModel<ObjectAdapterMemento>)modelObject, this.getScalarModel());
            this.setChoices(actionArgsHint);
            this.addStandardSemantics();
        } else {
            this.select2Field.clearInput();
        }
        FormComponentLabel labelIfRegular = this.createFormComponentLabel();
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.select2Field);
        this.addAdditionalLinksTo(labelIfRegular);
        return labelIfRegular;
    }

    private List<ObjectAdapterMemento> getChoiceMementos(ObjectAdapter[] argumentsIfAvailable) {
        List choices = this.scalarModel.getChoices(argumentsIfAvailable);
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    protected void addStandardSemantics() {
        this.setRequiredIfSpecified();
    }

    private void setRequiredIfSpecified() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        boolean required = scalarModel.isRequired();
        this.select2Field.setRequired(required);
    }

    protected FormComponentLabel createFormComponentLabel() {
        String name = ((ScalarModel)this.getModel()).getName();
        this.select2Field.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormComponentLabel labelIfRegular = new FormComponentLabel(ID_SCALAR_IF_REGULAR, this.select2Field);
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        Label scalarName = new Label(ID_SCALAR_NAME, this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.select2Field));
        labelIfRegular.add(new Component[]{scalarName});
        labelIfRegular.add(new Component[]{this.select2Field});
        return labelIfRegular;
    }

    @Override
    protected Component addComponentForCompact() {
        Label labelIfCompact = new Label(ID_SCALAR_IF_COMPACT, ((ScalarModel)this.getModel()).getObjectAsString());
        this.addOrReplace(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    protected ChoiceProvider<ObjectAdapterMemento> newChoiceProvider(final List<ObjectAdapterMemento> choicesMementos) {
        ObjectAdapterMementoProviderAbstract provider = new ObjectAdapterMementoProviderAbstract(this.getScalarModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public Collection<ObjectAdapterMemento> toChoices(final Collection<String> ids) {
                List<ObjectAdapterMemento> mementos = this.obtainMementos(null);
                Predicate<ObjectAdapterMemento> predicate = new Predicate<ObjectAdapterMemento>(){

                    public boolean apply(ObjectAdapterMemento input) {
                        String id = (String)this.getId(input);
                        return ids.contains(id);
                    }
                };
                return Collections2.filter(mementos, (Predicate)predicate);
            }

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                return choicesMementos;
            }
        };
        return provider;
    }

    @Override
    protected boolean alwaysRebuildGui() {
        return true;
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        this.select2Field.setEnabled(false);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        this.select2Field.setEnabled(true);
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.setTitleAttribute(disableReason);
    }

    private void setTitleAttribute(String titleAttribute) {
        this.getComponentForRegular().add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.select2Field.add(new Behavior[]{behavior});
    }

    @Override
    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        this.setChoices(argsIfAvailable);
        return true;
    }

    private void setChoices(ObjectAdapter[] argsIfAvailable) {
        List<ObjectAdapterMemento> choicesMementos = this.getChoiceMementos(argsIfAvailable);
        ChoiceProvider<ObjectAdapterMemento> provider = this.newChoiceProvider(choicesMementos);
        this.select2Field.setProvider(provider);
        ((ScalarModel)this.getModel()).clearPending();
        ObjectAdapterMemento objectAdapterMemento = ((ScalarModel)this.getModel()).getObjectAdapterMemento();
        if (objectAdapterMemento == null) {
            this.select2Field.getModel().setObject(null);
        } else if (!choicesMementos.contains(objectAdapterMemento)) {
            ObjectAdapterMemento newAdapterMemento = !choicesMementos.isEmpty() ? choicesMementos.get(0) : null;
            this.select2Field.getModel().setObject((Object)newAdapterMemento);
            ((ScalarModel)this.getModel()).setObject(newAdapterMemento != null ? newAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null);
        }
    }

    public ObjectAdapterMemento getPending() {
        return this.pending;
    }

    public void setPending(ObjectAdapterMemento pending) {
        this.pending = pending;
    }

    public ScalarModel getScalarModel() {
        return this.scalarModel;
    }
}

