/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.zclip;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintsBroadcastEvent;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindow;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowForm;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowPanel;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ZeroClipboardPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_SUBSCRIBING_LINK = "subscribingLink";
    private static final String ID_COPY_LINK = "copyLink";
    private static final String ID_SIMPLE_CLIPBOARD_MODAL_WINDOW = "simpleClipboardModalWindow";
    private AbstractLink subscribingLink;
    private AjaxLink<ObjectAdapter> copyLink;
    private SimpleClipboardModalWindow simpleClipboardModalWindow;

    public ZeroClipboardPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.copyLink == null) {
            this.copyLink = this.createLink(ID_COPY_LINK);
            this.addOrReplace(new Component[]{this.copyLink});
        }
        this.addSubscribingLink(null);
        this.addSimpleClipboardModalWindow();
    }

    private AjaxLink<ObjectAdapter> createLink(String linkId) {
        return this.newSimpleClipboardLink(linkId);
    }

    private AjaxLink<ObjectAdapter> newSimpleClipboardLink(String linkId) {
        return new AjaxLink<ObjectAdapter>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                String contentId = ZeroClipboardPanel.this.simpleClipboardModalWindow.getContentId();
                SimpleClipboardModalWindowPanel panel = new SimpleClipboardModalWindowPanel(contentId);
                SimpleClipboardModalWindowForm form = new SimpleClipboardModalWindowForm("form");
                TextField textField = new TextField("textField", (IModel)new LoadableDetachableModel<String>(){
                    private static final long serialVersionUID = 1L;

                    protected String load() {
                        if (ZeroClipboardPanel.this.subscribingLink instanceof BookmarkablePageLink) {
                            BookmarkablePageLink link = (BookmarkablePageLink)ZeroClipboardPanel.this.subscribingLink;
                            Class pageClass = link.getPageClass();
                            PageParameters pageParameters = link.getPageParameters();
                            CharSequence urlFor = link.urlFor(pageClass, pageParameters);
                            return this.getRequestCycle().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlFor));
                        }
                        return "";
                    }
                });
                panel.add(new Component[]{form});
                form.add(new Component[]{textField});
                textField.setOutputMarkupId(true);
                ZeroClipboardPanel.this.simpleClipboardModalWindow.setPanel((Component)panel, target);
                ZeroClipboardPanel.this.simpleClipboardModalWindow.show(target);
                target.focusComponent((Component)textField);
            }
        };
    }

    private void addSubscribingLink(UiHintContainer uiHintContainer) {
        if (uiHintContainer == null && this.subscribingLink != null) {
            return;
        }
        this.subscribingLink = this.createSubscribingLink(uiHintContainer);
        this.addOrReplace(new Component[]{this.subscribingLink});
        this.subscribingLink.setOutputMarkupId(true);
    }

    private void addSimpleClipboardModalWindow() {
        this.simpleClipboardModalWindow = SimpleClipboardModalWindow.newModalWindow(ID_SIMPLE_CLIPBOARD_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.simpleClipboardModalWindow});
    }

    private AbstractLink createSubscribingLink(UiHintContainer uiHintContainer) {
        if (uiHintContainer == null || !(uiHintContainer instanceof EntityModel)) {
            AbstractLink link = new AbstractLink(ID_SUBSCRIBING_LINK){
                private static final long serialVersionUID = 1L;
            };
            return link;
        }
        EntityModel entityModel = (EntityModel)uiHintContainer;
        PageParameters pageParameters = entityModel.getPageParameters();
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ENTITY);
        return Links.newBookmarkablePageLink(ID_SUBSCRIBING_LINK, pageParameters, pageClass);
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (!(event.getPayload() instanceof UiHintsBroadcastEvent)) {
            return;
        }
        UiHintsBroadcastEvent ev = (UiHintsBroadcastEvent)event.getPayload();
        this.addSubscribingLink(ev.getUiHintContainer());
        AjaxRequestTarget target = ev.getTarget();
        if (target != null) {
            target.add(new Component[]{this.subscribingLink});
        }
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }
}

