/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.isis.viewer.wicket.ui.errors.StackTraceDetail;

public class ExceptionModel
extends ModelAbstract<Exception> {
    private static final long serialVersionUID = 1L;
    private static final String MAIN_MESSAGE_IF_NOT_RECOGNIZED = "Sorry, an unexpected error occurred.";
    private Exception exception;
    private boolean recognized;
    private final String mainMessage;

    public static ExceptionModel create(String recognizedMessageIfAny, Exception ex) {
        return recognizedMessageIfAny != null ? new ExceptionModel(recognizedMessageIfAny, true, ex) : new ExceptionModel(MAIN_MESSAGE_IF_NOT_RECOGNIZED, false, ex);
    }

    private ExceptionModel(String mainMessage, boolean recognized, Exception ex) {
        this.mainMessage = mainMessage;
        this.recognized = recognized;
        this.exception = ex;
    }

    protected Exception load() {
        return this.exception;
    }

    public void setObject(Exception ex) {
        if (ex == null) {
            return;
        }
        this.exception = ex;
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public List<StackTraceDetail> getStackTrace() {
        return ExceptionModel.asStackTrace(this.exception);
    }

    private static List<StackTraceDetail> asStackTrace(Throwable ex) {
        ArrayList stackTrace = Lists.newArrayList();
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable cause : causalChain) {
            stackTrace.add(StackTraceDetail.exceptionClassName(cause));
            stackTrace.add(StackTraceDetail.exceptionMessage(cause));
            ExceptionModel.addStackTraceElements(cause, stackTrace);
            cause = cause.getCause();
        }
        return stackTrace;
    }

    private static void addStackTraceElements(Throwable ex, List<StackTraceDetail> stackTrace) {
        for (StackTraceElement el : ex.getStackTrace()) {
            stackTrace.add(StackTraceDetail.element(el));
        }
    }
}

