/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.StackTraceListView;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class ExceptionStackTracePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_MAIN_MESSAGE = "mainMessage";
    private static final String ID_EXCEPTION_DETAIL = "exceptionDetail";
    private static final String ID_STACK_TRACE_ELEMENT = "stackTraceElement";
    private static final String ID_LINE = "stackTraceElementLine";
    private static final JavaScriptResourceReference DIV_TOGGLE_JS = new JavaScriptResourceReference(ExceptionStackTracePanel.class, "div-toggle.js");

    public ExceptionStackTracePanel(String id, ExceptionModel exceptionModel) {
        super(id, (IModel)exceptionModel);
        this.add(new Component[]{new Label(ID_MAIN_MESSAGE, exceptionModel.getMainMessage()).setEscapeModelStrings(false)});
        WebMarkupContainer container = new WebMarkupContainer(ID_EXCEPTION_DETAIL){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)DIV_TOGGLE_JS));
            }
        };
        container.add(new Component[]{new StackTraceListView(ID_STACK_TRACE_ELEMENT, ID_LINE, exceptionModel.getStackTrace())});
        this.add(new Component[]{container});
    }

    public void renderHead(IHeaderResponse response) {
        PanelUtil.renderHead(response, ((Object)((Object)this)).getClass());
    }
}

