/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.core.commons.authentication.MessageBroker;

public class JGrowlUtil {
    private JGrowlUtil() {
    }

    public static String asJGrowlCalls(MessageBroker messageBroker) {
        StringBuilder buf = new StringBuilder();
        for (String info : messageBroker.getMessages()) {
            JGrowlUtil.addJGrowlCall(info, "INFO", false, buf);
        }
        for (String warning : messageBroker.getWarnings()) {
            JGrowlUtil.addJGrowlCall(warning, "WARNING", true, buf);
        }
        String error = messageBroker.getApplicationError();
        if (error != null) {
            JGrowlUtil.addJGrowlCall(error, "ERROR", true, buf);
        }
        return buf.toString();
    }

    public static void addJGrowlCall(String origMsg, String cssClassSuffix, boolean sticky, StringBuilder buf) {
        String msg = origMsg.replaceAll("\"", "'");
        buf.append("$.jGrowl(\"").append(msg).append('\"');
        buf.append(", {");
        buf.append("theme: \"jgrowl-").append(cssClassSuffix).append("\"");
        if (sticky) {
            buf.append(", sticky: true");
        }
        buf.append("}");
        buf.append(");\n");
    }
}

