/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.hints.UiHintsBroadcastEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintsEventAbstract;
import org.apache.isis.viewer.wicket.model.hints.UiHintsSetEvent;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.ApplicationActionsModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.ZeroClipboardPanel;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.isis.viewer.wicket.ui.overlays.Overlays;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.about.AboutPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageAbstract
extends WebPage
implements ActionPromptProvider {
    private static Logger LOG = LoggerFactory.getLogger(PageAbstract.class);
    private static final long serialVersionUID = 1L;
    private static final JavaScriptResourceReference JQUERY_JGROWL_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.jgrowl.js");
    private static final String REGULAR_CASE_KEY = "isis.viewer.wicket.regularCase";
    private static final JavaScriptResourceReference JQUERY_LIVEQUERY_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.livequery.js");
    private static final JavaScriptResourceReference JQUERY_ISIS_WICKET_VIEWER_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.isis.wicket.viewer.js");
    private static final String ID_THEME = "theme";
    private static final String ID_BOOKMARKED_PAGES = "bookmarks";
    private static final String ID_HOME_PAGE_LINK = "homePageLink";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_USER_NAME = "userName";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final String ID_PAGE_TITLE = "pageTitle";
    public static final String ID_MENU_LINK = "menuLink";
    public static final String ID_LOGOUT_LINK = "logoutLink";
    public static final String ID_ABOUT_LINK = "aboutLink";
    private static final String ID_COPY_LINK = "copyLink";
    private static final String ID_BREADCRUMBS = "breadcrumbs";
    public static ThreadLocal<ExceptionModel> EXCEPTION = new ThreadLocal();
    private final List<ComponentType> childComponentIds;
    private final PageParameters pageParameters;
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject
    @Named(value="applicationJs")
    private String applicationJs;
    @Inject
    private PageClassRegistry pageClassRegistry;
    private ActionPromptModalWindow actionPromptModalWindow;
    protected MarkupContainer themeDiv;

    public PageAbstract(PageParameters pageParameters, ApplicationActions applicationActions, String title, ComponentType ... childComponentIds) {
        try {
            this.getSession().bind();
            this.setTitle(title);
            this.themeDiv = new WebMarkupContainer(ID_THEME);
            this.add(new Component[]{this.themeDiv});
            if (this.applicationName != null) {
                this.themeDiv.add(new Behavior[]{new CssClassAppender(PageAbstract.asCssStyle(this.applicationName))});
            }
            this.addApplicationActions(this.themeDiv, applicationActions);
            this.childComponentIds = Collections.unmodifiableList(Arrays.asList(childComponentIds));
            this.pageParameters = pageParameters;
            this.addHomePageLinkAndApplicationName();
            this.addUserName();
            this.addLogoutLink();
            this.addAboutLink();
            this.addBreadcrumbs();
            this.addCopyLink();
            this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to construct page, going back to sign in page", (Throwable)ex);
            List exceptionRecognizers = this.getServicesInjector().lookupServices(ExceptionRecognizer.class);
            String recognizedMessageIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
            ExceptionModel exceptionModel = ExceptionModel.create(recognizedMessageIfAny, ex);
            this.getSession().invalidate();
            this.getSession().clear();
            EXCEPTION.set(exceptionModel);
            throw new RestartResponseAtInterceptPageException(this.getSignInPage());
        }
    }

    protected void setTitle(String title) {
        this.addOrReplace(new Component[]{new Label(ID_PAGE_TITLE, title != null ? title : this.applicationName)});
    }

    private Class<? extends Page> getSignInPage() {
        return this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
    }

    private static String asCssStyle(String str) {
        return StringExtensions.asLowerDashed((String)str);
    }

    protected ExceptionModel recognizeException(Exception ex) {
        List exceptionRecognizers;
        try {
            exceptionRecognizers = this.getServicesInjector().lookupServices(ExceptionRecognizer.class);
        }
        catch (Exception ex2) {
            LOG.warn("Unable to obtain exceptionRecognizers (no session?)");
            exceptionRecognizers = Collections.emptyList();
        }
        String recognizedMessageIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
        return ExceptionModel.create(recognizedMessageIfAny, ex);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_JGROWL_JS));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_LIVEQUERY_JS));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_ISIS_WICKET_VIEWER_JS));
        String feedbackMsg = JGrowlUtil.asJGrowlCalls(this.getMessageBroker());
        if (!Strings.isNullOrEmpty((String)feedbackMsg)) {
            OnDomReadyHeaderItem forScript = OnDomReadyHeaderItem.forScript((CharSequence)feedbackMsg);
            response.render((HeaderItem)forScript);
        }
        if (this.getConfiguration().getBoolean(REGULAR_CASE_KEY, false)) {
            response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)PanelUtil.cssResourceReferenceFor(Overlays.class, "regular-case")));
        }
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
    }

    private void addHomePageLinkAndApplicationName() {
        ExternalLink homePageLink = new ExternalLink(ID_HOME_PAGE_LINK, "/wicket/");
        homePageLink.setContextRelative(true);
        this.themeDiv.add(new Component[]{homePageLink});
        homePageLink.add(new Component[]{new Label(ID_APPLICATION_NAME, this.applicationName)});
    }

    private void addUserName() {
        this.themeDiv.add(new Component[]{new Label(ID_USER_NAME, this.getAuthenticationSession().getUserName())});
    }

    private void addLogoutLink() {
        this.themeDiv.add(new Component[]{new Link<Object>(ID_LOGOUT_LINK){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.getSession().invalidate();
                this.setResponsePage(PageAbstract.this.getSignInPage());
            }
        }});
    }

    private void addAboutLink() {
        this.themeDiv.add(new Component[]{new Link<Object>(ID_ABOUT_LINK){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.setResponsePage(AboutPage.class);
            }
        }});
    }

    private void addBreadcrumbs() {
        BreadcrumbPanel breadcrumbPanel = new BreadcrumbPanel(ID_BREADCRUMBS);
        this.themeDiv.addOrReplace(new Component[]{breadcrumbPanel});
    }

    private void addCopyLink() {
        ZeroClipboardPanel zClipCopyLink = new ZeroClipboardPanel(ID_COPY_LINK);
        this.themeDiv.addOrReplace(new Component[]{zClipCopyLink});
    }

    public List<ComponentType> getChildModelTypes() {
        return this.childComponentIds;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    private void addApplicationActions(MarkupContainer container, ApplicationActions applicationActions) {
        if (applicationActions == ApplicationActions.INCLUDE) {
            this.addActionPromptModalWindow();
            ApplicationActionsModel model = new ApplicationActionsModel();
            model.setActionPromptModalWindowProvider((ActionPromptProvider)this);
            this.addComponent(container, ComponentType.APPLICATION_ACTIONS, (IModel<?>)model);
        } else {
            Components.permanentlyHide(container, ComponentType.APPLICATION_ACTIONS);
            Components.permanentlyHide(container, ID_ACTION_PROMPT_MODAL_WINDOW);
        }
    }

    protected void addChildComponents(MarkupContainer container, IModel<?> model) {
        for (ComponentType componentType : this.getChildModelTypes()) {
            this.addComponent(container, componentType, model);
        }
    }

    private void addComponent(MarkupContainer container, ComponentType componentType, IModel<?> model) {
        this.getComponentFactoryRegistry().addOrReplaceComponent(container, componentType, model);
    }

    protected void addBookmarkedPages() {
        this.getComponentFactoryRegistry().addOrReplaceComponent(this.themeDiv, ID_BOOKMARKED_PAGES, ComponentType.BOOKMARKED_PAGES, (IModel<?>)this.getBookmarkedPagesModel());
    }

    protected void bookmarkPage(BookmarkableModel<?> model) {
        this.getBookmarkedPagesModel().bookmarkPage(model);
    }

    protected void removeAnyBookmark(EntityModel model) {
        this.getBookmarkedPagesModel().remove(model);
    }

    private BookmarkedPagesModel getBookmarkedPagesModel() {
        BookmarkedPagesModelProvider session = (BookmarkedPagesModelProvider)this.getSession();
        return session.getBookmarkedPagesModel();
    }

    public ActionPrompt getActionPrompt() {
        return ActionPromptModalWindow.getActionPromptModalWindowIfEnabled(this.actionPromptModalWindow);
    }

    private void addActionPromptModalWindow() {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        this.themeDiv.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }

    public void onEvent(IEvent<?> event) {
        Object payload = event.getPayload();
        if (payload instanceof UiHintsSetEvent) {
            UiHintsSetEvent setEv = (UiHintsSetEvent)payload;
            UiHintsBroadcastEvent broadcastEv = new UiHintsBroadcastEvent((UiHintsEventAbstract)setEv);
            this.send((IEventSink)this, Broadcast.BREADTH, broadcastEv);
        }
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        ComponentFactoryRegistryAccessor cfra = (ComponentFactoryRegistryAccessor)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }

    protected ServicesInjectorSpi getServicesInjector() {
        return this.getPersistenceSession().getServicesInjector();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected MessageBroker getMessageBroker() {
        return IsisContext.getMessageBroker();
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    protected static enum ApplicationActions {
        INCLUDE,
        EXCLUDE;

    }
}

