/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.entity;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintsBroadcastEvent;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class EntityPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityModel model;

    public EntityPage(PageParameters pageParameters) {
        this(pageParameters, new EntityModel(pageParameters));
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel) {
        this(pageParameters, entityModel, null);
    }

    public EntityPage(ObjectAdapter adapter) {
        this(adapter, null);
    }

    public EntityPage(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        this(new PageParameters(), EntityPage.newEntityModel(adapter, exIfAny));
    }

    private static EntityModel newEntityModel(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        EntityModel model = new EntityModel(adapter);
        model.setException(exIfAny);
        return model;
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel, String titleString) {
        super(pageParameters, PageAbstract.ApplicationActions.INCLUDE, titleString, ComponentType.ENTITY);
        ObjectAdapter objectAdapter;
        this.model = entityModel;
        try {
            objectAdapter = (ObjectAdapter)entityModel.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw ex;
        }
        if (!this.getDeploymentType().isProduction()) {
            this.getSpecificationLoader().invalidateCacheFor(objectAdapter.getObject());
        }
        if (titleString == null) {
            String titleStr = objectAdapter.titleString(null);
            this.setTitle(titleStr);
        }
        this.addChildComponents(this.themeDiv, (IModel<?>)this.model);
        this.bookmarkPage((BookmarkableModel<?>)this.model);
        this.addBreadcrumb(entityModel);
        this.addBookmarkedPages();
        this.send((IEventSink)this, Broadcast.BREADTH, new UiHintsBroadcastEvent((UiHintContainer)entityModel));
    }

    private void addBreadcrumb(EntityModel entityModel) {
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.visited(entityModel);
    }

    private void removeAnyBreadcrumb(EntityModel entityModel) {
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.remove(entityModel);
    }

    protected void onBeforeRender() {
        this.model.load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        super.onBeforeRender();
    }

    private DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }
}

