/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.home;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.actions.homepage.HomePageFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class HomePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;

    public HomePage() {
        super(new PageParameters(), PageAbstract.ApplicationActions.INCLUDE, null, new ComponentType[0]);
        this.addChildComponents(this.themeDiv, null);
        this.buildGui();
        this.addBookmarkedPages();
    }

    private void buildGui() {
        ObjectAndAction objectAndAction = this.lookupHomePageAction();
        if (objectAndAction != null) {
            Components.permanentlyHide(this.themeDiv, ComponentType.WELCOME);
            ActionModel actionModel = ActionModel.create((ObjectAdapter)objectAndAction.objectAdapter, (ObjectAction)objectAndAction.action);
            this.getComponentFactoryRegistry().addOrReplaceComponent(this.themeDiv, ComponentType.ACTION_PROMPT, (IModel<?>)actionModel);
        } else {
            Components.permanentlyHide(this.themeDiv, ComponentType.ACTION_PROMPT);
            this.getComponentFactoryRegistry().addOrReplaceComponent(this.themeDiv, ComponentType.WELCOME, null);
        }
    }

    private ObjectAndAction lookupHomePageAction() {
        List serviceAdapters = this.getPersistenceSession().getServices();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            List objectActions = serviceSpec.getObjectActions(Contributed.EXCLUDED);
            for (ObjectAction objectAction : objectActions) {
                if (!objectAction.containsFacet(HomePageFacet.class)) continue;
                return new ObjectAndAction(serviceAdapter, objectAction);
            }
        }
        return null;
    }

    private static class ObjectAndAction {
        ObjectAdapter objectAdapter;
        ObjectAction action;

        ObjectAndAction(ObjectAdapter serviceAdapter, ObjectAction objectAction) {
            this.objectAdapter = serviceAdapter;
            this.action = objectAction;
        }
    }
}

