/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionStackTracePanel;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.authroles.authentication.panel.SignInPanel;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class WicketSignInPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    private static final String ID_EXCEPTION_STACK_TRACE = "exceptionStackTrace";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject
    @Named(value="applicationJs")
    private String applicationJs;

    private static ExceptionModel getAndClearExceptionModelIfAny() {
        ExceptionModel exceptionModel = PageAbstract.EXCEPTION.get();
        PageAbstract.EXCEPTION.remove();
        return exceptionModel;
    }

    public WicketSignInPage() {
        this(null);
    }

    public WicketSignInPage(PageParameters parameters) {
        this(parameters, WicketSignInPage.getAndClearExceptionModelIfAny());
    }

    public WicketSignInPage(PageParameters parameters, ExceptionModel exceptionModel) {
        this.addPageTitle();
        this.addApplicationName();
        this.addSignInPanel();
        if (exceptionModel != null) {
            this.add(new Component[]{new ExceptionStackTracePanel(ID_EXCEPTION_STACK_TRACE, exceptionModel)});
        } else {
            this.add(new Component[]{new WebMarkupContainer(ID_EXCEPTION_STACK_TRACE).setVisible(false)});
        }
    }

    private MarkupContainer addPageTitle() {
        return this.add(new Component[]{new Label(ID_PAGE_TITLE, this.applicationName)});
    }

    private void addApplicationName() {
        this.add(new Component[]{new Label(ID_APPLICATION_NAME, this.applicationName)});
    }

    protected SignInPanel addSignInPanel() {
        boolean suppressRememberMe = this.getConfiguration().getBoolean("isis.viewer.wicket.suppressRememberMe", false);
        boolean rememberMe = !suppressRememberMe;
        return this.addSignInPanel(rememberMe);
    }

    private SignInPanel addSignInPanel(boolean rememberMe) {
        SignInPanel signInPanel = new SignInPanel("signInPanel", rememberMe);
        this.add(new Component[]{signInPanel});
        return signInPanel;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }
}

