/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.mmverror;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;

public class MmvErrorPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject
    @Named(value="applicationJs")
    private String applicationJs;
    private static final String ID_ERROR = "error";
    private static final String ID_ERROR_MESSAGE = "errorMessage";

    public MmvErrorPage(IModel<List<? extends String>> model) {
        super(model);
        this.addPageTitle();
        this.addApplicationName();
        this.addValidationErrors();
    }

    private IModel<List<? extends String>> getModel() {
        return this.getDefaultModel();
    }

    private MarkupContainer addPageTitle() {
        return this.add(new Component[]{new Label(ID_PAGE_TITLE, this.applicationName)});
    }

    private void addApplicationName() {
        this.add(new Component[]{new Label(ID_APPLICATION_NAME, this.applicationName)});
    }

    private void addValidationErrors() {
        class ValidationErrorListView
        extends ListView<String> {
            private static final long serialVersionUID = 1L;
            private final String idLine;

            public ValidationErrorListView(String id, String idLine, IModel<List<? extends String>> model) {
                super(id, model);
                this.idLine = idLine;
            }

            protected void populateItem(ListItem<String> item) {
                String validationError = (String)item.getModelObject();
                item.add(new Component[]{new Label(this.idLine, validationError)});
            }
        }
        this.add(new Component[]{new ValidationErrorListView(ID_ERROR, ID_ERROR_MESSAGE, this.getModel())});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }
}

