/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.value;

import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class ValuePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";

    public ValuePage(ValueModel valueModel) {
        this(valueModel, ValuePage.actionNameFrom(valueModel));
    }

    private ValuePage(ValueModel valueModel, String actionName) {
        super(new PageParameters(), PageAbstract.ApplicationActions.INCLUDE, actionName, ComponentType.VALUE);
        this.themeDiv.addOrReplace(new Component[]{new Label(ID_ACTION_NAME, actionName)});
        this.addChildComponents(this.themeDiv, (IModel<?>)valueModel);
        this.addBookmarkedPages();
    }

    private static String actionNameFrom(ValueModel valueModel) {
        ActionModel actionModel = valueModel.getActionModelHint();
        if (actionModel != null) {
            return actionModel.getActionMemento().getAction().getName();
        }
        return "Results";
    }
}

