/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.Persistor;
import org.apache.isis.viewer.wicket.model.isis.PersistenceSessionProvider;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.IFormSubmitterWithPreValidateHook;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class FormAbstract<T>
extends Form<T>
implements IHeaderContributor,
ComponentFactoryRegistryAccessor,
PageClassRegistryAccessor,
AuthenticationSessionProvider,
PersistenceSessionProvider {
    private static final long serialVersionUID = 1L;
    private String preValidationErrorIfAny;
    @Inject
    private ComponentFactoryRegistry componentFactoryRegistry;

    public FormAbstract(String id) {
        super(id);
    }

    public FormAbstract(String id, IModel<T> model) {
        super(id, model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.renderHead(response, this.getClass());
    }

    protected void renderHead(IHeaderResponse response, Class<?> cls) {
        String url = cls.getSimpleName() + ".css";
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(cls, url)));
    }

    protected String getPreValidationErrorIfAny() {
        return this.preValidationErrorIfAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(final IFormSubmitter submittingComponent) {
        try {
            if (submittingComponent instanceof IFormSubmitterWithPreValidateHook) {
                IFormSubmitterWithPreValidateHook componentWithPreSubmitHook = (IFormSubmitterWithPreValidateHook)submittingComponent;
                this.preValidationErrorIfAny = componentWithPreSubmitHook.preValidate();
            }
            if (this.preValidationErrorIfAny != null) {
                AdapterManager.ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FormAbstract.super.process(submittingComponent);
                    }
                });
            } else {
                super.process(submittingComponent);
            }
        }
        finally {
            this.preValidationErrorIfAny = null;
        }
    }

    @Override
    public ComponentFactoryRegistry getComponentFactoryRegistry() {
        return this.componentFactoryRegistry;
    }

    @Override
    public PageClassRegistry getPageClassRegistry() {
        return ((PageClassRegistryAccessor)this.getApplication()).getPageClassRegistry();
    }

    public IsisContext getIsisContext() {
        return IsisContext.getInstance();
    }

    public Persistor getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    public AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected List<ObjectAdapter> getServiceAdapters() {
        return IsisContext.getPersistenceSession().getServices();
    }

    public void injectInto(Object candidate) {
        if (AuthenticationSessionProviderAware.class.isAssignableFrom(candidate.getClass())) {
            AuthenticationSessionProviderAware cast = (AuthenticationSessionProviderAware)AuthenticationSessionProviderAware.class.cast(candidate);
            cast.setAuthenticationSessionProvider((AuthenticationSessionProvider)this);
        }
    }
}

